/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.IOpenable;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class OpenableAction
extends Action {
    private IOpenable openable;

    public static OpenableAction[] createOpenableActions(IOpenable[] openables, boolean useOpenPrefix) {
        if (openables != null && openables.length > 0) {
            OpenableAction[] actions = new OpenableAction[openables.length];
            int i = 0;
            while (i < openables.length) {
                actions[i] = new OpenableAction(openables[i], useOpenPrefix);
                ++i;
            }
            return actions;
        }
        return new OpenableAction[0];
    }

    public OpenableAction(IOpenable openable, boolean useLabelPrefix) {
        this.openable = openable;
        if (useLabelPrefix) {
            this.setText(NLS.bind((String)Messages.openLabelPrefix, (Object)DTRTUtil.getLabel((IDescribable)openable)));
        } else {
            this.setText(DTRTUtil.getLabel((IDescribable)openable));
        }
        Image image = DTRTUIUtil.getImage(openable);
        if (image != null) {
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        }
        this.setToolTipText(DTRTUtil.getToolTipText((IDescribable)openable));
        this.setEnabled(openable != null);
    }

    public void run() {
        try {
            this.openable.openEditor();
        }
        catch (CoreException e) {
            UIExceptionHandler.DEFAULT.handleException((Exception)((Object)e));
        }
    }

    private static class Messages
    extends NLS {
        public static String openLabelPrefix;

        static {
            NLS.initializeMessages((String)OpenableAction.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

