/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.widgets.FormText;

public abstract class FormTextHTMLGenerator {
    private static final String LINKED_OBJECTS = "LinkedObjects";
    private static final String KEY_PREFIX = "FTImg_";
    private int imageCounter;
    private List<Object> objects;
    private FormText formText;
    protected StringBuilder sb = new StringBuilder();
    protected boolean parseTags;

    public static Object decodeHRef(FormText formText, Object href) {
        Object data;
        if (formText != null && !formText.isDisposed() && href instanceof String && (data = formText.getData(LINKED_OBJECTS)) instanceof List) {
            List objects = (List)data;
            String key = (String)href;
            if (key.startsWith(KEY_PREFIX)) {
                try {
                    int index = Integer.parseInt(key.substring(KEY_PREFIX.length()));
                    return objects.get(index);
                }
                catch (Exception e) {
                    DTRTUIBundle.log(e);
                }
            }
        }
        return null;
    }

    private FormTextHTMLGenerator(FormText formText) {
        if (formText == null) {
            throw new IllegalArgumentException("FormText cannot be null");
        }
        if (formText.isDisposed()) {
            throw new IllegalArgumentException("FormText cannot be disposed");
        }
        this.formText = formText;
        formText.setData(LINKED_OBJECTS, null);
    }

    public boolean addImage(Image image) {
        if (image != null && !image.isDisposed()) {
            this.parseTags = true;
            String key = KEY_PREFIX + this.imageCounter++;
            this.sb.append("<img align=\"middle\" href=\"").append(key).append("\"/> ");
            this.formText.setImage(key, image);
            return true;
        }
        return false;
    }

    public boolean addObjectLink(String text, Object object) {
        return this.addObjectLink(text, null, object);
    }

    public boolean addObjectLink(String text, String toolTipText, Object object) {
        if (text != null && object != null) {
            this.parseTags = true;
            if (this.objects == null) {
                this.objects = new ArrayList<Object>();
            }
            String key = KEY_PREFIX + this.objects.size();
            this.objects.add(object);
            this.sb.append("<a");
            this.sb.append(" href=\"").append(key).append('\"');
            if (!DTRTUtil.isEmpty((String)toolTipText)) {
                this.sb.append(" alt=\"").append(toolTipText).append('\"');
            }
            this.sb.append(">").append(text).append("</a>");
            return true;
        }
        return false;
    }

    public boolean isFlushed() {
        return this.imageCounter < 0;
    }

    public void flush() throws IllegalStateException {
        if (this.isFlushed()) {
            throw new IllegalStateException("Generator is already flushed.");
        }
        this.closeHTML();
        this.formText.setText(this.sb.toString(), this.parseTags, this.objects != null);
        if (this.objects != null) {
            this.formText.setData(LINKED_OBJECTS, this.objects);
            this.formText.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    FormTextHTMLGenerator.this.formText.setData(FormTextHTMLGenerator.LINKED_OBJECTS, null);
                }
            });
        }
        this.objects = null;
        this.imageCounter = -1;
    }

    protected abstract void closeHTML();

    /* synthetic */ FormTextHTMLGenerator(FormText formText, FormTextHTMLGenerator formTextHTMLGenerator) {
        this(formText);
    }

    public static class HTMLText
    extends FormTextHTMLGenerator {
        public HTMLText(FormText formText) {
            super(formText, null);
            this.parseTags = true;
            this.sb.append("<form><p>");
        }

        public boolean addEncodedText(String text) {
            this.sb.append(text);
            return true;
        }

        @Override
        protected void closeHTML() {
            this.sb.append("</p></form>");
        }
    }

    public static class HTMLUnorderedList
    extends FormTextHTMLGenerator {
        private static final String WHITE_BULLET = "\u25e6";
        private int liCounter;
        private String bulletSymbol;
        private int bulletIndent;

        public HTMLUnorderedList(FormText formText) {
            super(formText, null);
            this.parseTags = true;
            this.sb.append("<ul>");
            this.setUseWhiteBullet(true);
        }

        public void setBulletSymbol(String bulletSymbol) {
            this.bulletSymbol = bulletSymbol;
        }

        public String getBulletSymbol() {
            return this.bulletSymbol;
        }

        public void setBulletIndent(int bulletIndent) {
            this.bulletIndent = bulletIndent;
        }

        public int getBulletIndent() {
            return this.bulletIndent;
        }

        public void setUseWhiteBullet(boolean whiteBullet) {
            if (whiteBullet) {
                this.bulletSymbol = WHITE_BULLET;
                this.bulletIndent = 5;
            } else {
                this.bulletSymbol = null;
                this.bulletIndent = 0;
            }
        }

        public boolean isUseWhiteBullet() {
            return WHITE_BULLET.equals(this.bulletSymbol);
        }

        public boolean addEncodedText(String text) {
            this.sb.append('\n').append(text);
            return true;
        }

        public boolean addLI(Image image, Object object, String encodedText) {
            return this.addLI(null, image, object, encodedText, null, null);
        }

        public boolean addLI(String encodedTextPrefix, Image image, Object object, String encodedLinkText, String encodedLinkToolTipText, String encodedTextSuffix) {
            boolean added = false;
            this.sb.append("\n<li");
            if (this.getBulletIndent() > 0) {
                this.sb.append(" indent=\"").append(this.getBulletIndent()).append('\"');
            }
            if (this.getBulletSymbol() != null) {
                this.sb.append(" style=\"text\" value=\"").append(this.getBulletSymbol()).append('\"');
                this.sb.append("> ");
            } else {
                this.sb.append('>');
            }
            if (!DTRTUtil.isEmpty((String)encodedTextPrefix)) {
                added |= this.addEncodedText(encodedTextPrefix);
            }
            if (image != null) {
                added |= this.addImage(image);
            }
            if (object != null && encodedLinkText != null) {
                added |= this.addObjectLink(encodedLinkText, encodedLinkToolTipText, object);
            } else if (!DTRTUtil.isEmpty((String)encodedLinkText)) {
                added |= this.addEncodedText(encodedLinkText);
            }
            if (!DTRTUtil.isEmpty((String)encodedTextSuffix)) {
                added |= this.addEncodedText(encodedTextSuffix);
            }
            this.sb.append("</li>");
            if (added) {
                ++this.liCounter;
            }
            return added;
        }

        public int liCounter() {
            return this.liCounter;
        }

        @Override
        protected void closeHTML() {
            this.sb.append("\n</ul>");
        }
    }
}

