/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;

public final class DescribableTreeElement
implements IDescribable,
Comparable<IDescribable>,
IDisposable {
    private Object parent;
    private IDescribable describable;
    private ObjectList<Object> children;
    private Map<String, Object> dataMap;
    private int category;
    private Object data;

    public DescribableTreeElement(IDescribable describable) {
        assert (describable != null);
        this.describable = describable;
    }

    public DescribableTreeElement(Object parent, IDescribable describable) {
        assert (parent != null);
        assert (describable != null);
        this.parent = parent;
        this.describable = describable;
    }

    public void dispose() {
        this.parent = null;
        this.describable = null;
        this.data = null;
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
        if (this.dataMap != null) {
            this.dataMap.clear();
            this.dataMap = null;
        }
    }

    public IDescribable getDescribable() {
        return this.describable;
    }

    public IDescriptor getDescriptor() {
        return this.getDescribable().getDescriptor();
    }

    public Object getParent() {
        return this.parent;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public int getCategory() {
        return this.category;
    }

    public boolean childrenWasComputed() {
        return this.children != null;
    }

    public void addChild(Object child) {
        if (this.children == null) {
            this.children = new ObjectList();
        }
        this.children.add(child);
    }

    public void addChildren(Collection<?> children) {
        if (this.children == null) {
            this.children = new ObjectList(children);
        } else {
            this.children.add(children);
        }
    }

    public boolean removeChild(Object child) {
        if (this.children != null && this.children.remove(child)) {
            if (this.children.isEmpty()) {
                this.children.clear();
                this.children = null;
            }
            return true;
        }
        return false;
    }

    public void clearChildren() {
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
    }

    public List<?> getChildren() {
        return this.children != null ? this.children.getUnmodifiableView() : Collections.emptyList();
    }

    public void setData(String key, Object data) {
        if (data != null) {
            if (this.dataMap == null) {
                this.dataMap = new HashMap<String, Object>();
            }
            this.dataMap.put(key, data);
        } else if (this.dataMap != null && this.dataMap.remove(key) != null && this.dataMap.isEmpty()) {
            this.dataMap = null;
        }
    }

    public Object getData(String key) {
        return this.dataMap != null ? this.dataMap.get(key) : null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.describable == null ? 0 : this.describable.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DescribableTreeElement)) {
            return false;
        }
        DescribableTreeElement other = (DescribableTreeElement)obj;
        return DTRTUtil.equals((Object)this.describable, (Object)other.describable) && DTRTUtil.equals((Object)this.parent, (Object)other.parent);
    }

    @Override
    public int compareTo(IDescribable o) {
        if (o instanceof DescribableTreeElement) {
            int parentCompare;
            DescribableTreeElement element = (DescribableTreeElement)o;
            return this.getCategory() > element.getCategory() ? -1 : (this.getCategory() < element.getCategory() ? 1 : ((parentCompare = DTRTUtil.compare((Object)this.getParent(), (Object)element.getParent())) != 0 ? parentCompare : DTRTUtil.compare((Object)this.getDescribable(), (Object)element.getDescribable())));
        }
        return o == null ? -1 : DTRTUtil.compare((Object)this.getDescriptor(), (Object)o.getDescriptor());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DescribableTreeElement [parent=");
        builder.append(this.parent);
        builder.append(", describable=");
        builder.append(this.describable);
        builder.append("]");
        return builder.toString();
    }
}

