/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Image;

public class DecoratedImageManager {
    private Map<DecoratedImageKey, Image> decoratedImageMap = new HashMap<DecoratedImageKey, Image>();

    public void dispose() {
        if (this.decoratedImageMap != null) {
            for (Image image : this.decoratedImageMap.values()) {
                try {
                    image.dispose();
                }
                catch (Exception exception) {}
            }
            this.decoratedImageMap.clear();
            this.decoratedImageMap = null;
        }
    }

    public boolean isDisposed() {
        return this.decoratedImageMap == null;
    }

    public Image decorate(Image baseImage, DecorationHandle decorationHandle) {
        if (baseImage != null && decorationHandle != null) {
            DecoratedImageKey key = new DecoratedImageKey(baseImage, Collections.singleton(decorationHandle));
            Image decoratedImage = this.decoratedImageMap.get(key);
            if (decoratedImage == null || decoratedImage.isDisposed()) {
                DecorationOverlayIcon decorationIcon = new DecorationOverlayIcon(baseImage, decorationHandle.getImageDescriptor(), decorationHandle.getQuadrant());
                decoratedImage = decorationIcon.createImage();
                this.decoratedImageMap.put(key, decoratedImage);
            }
            return decoratedImage;
        }
        return baseImage;
    }

    public Image decorate(Image baseImage, Collection<DecorationHandle> decorationHandles) {
        if (baseImage != null && decorationHandles != null && !decorationHandles.isEmpty()) {
            DecoratedImageKey key = new DecoratedImageKey(baseImage, decorationHandles);
            Image decoratedImage = this.decoratedImageMap.get(key);
            if (decoratedImage == null || decoratedImage.isDisposed()) {
                ImageDescriptor[] imageDescriptors = new ImageDescriptor[5];
                for (DecorationHandle decorationHandle : decorationHandles) {
                    int index;
                    if (decorationHandle == null || imageDescriptors[index = decorationHandle.getQuadrant()] != null) continue;
                    imageDescriptors[index] = decorationHandle.getImageDescriptor();
                }
                DecorationOverlayIcon decorationIcon = new DecorationOverlayIcon(baseImage, imageDescriptors);
                decoratedImage = decorationIcon.createImage();
                this.decoratedImageMap.put(key, decoratedImage);
            }
            return decoratedImage;
        }
        return baseImage;
    }

    private static final class DecoratedImageKey {
        private final Image baseImage;
        private final List<String> decorationHandleIds;
        private int hashCode;

        public DecoratedImageKey(Image image, Collection<DecorationHandle> decorationHandles) {
            assert (image != null);
            assert (decorationHandles != null);
            assert (!decorationHandles.isEmpty());
            this.baseImage = image;
            ArrayList<String> ids = new ArrayList<String>(decorationHandles.size());
            for (DecorationHandle decorationHandle : decorationHandles) {
                if (decorationHandle == null) continue;
                ids.add(decorationHandle.getId());
            }
            this.decorationHandleIds = ids;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 1;
                result = 31 * result + (this.baseImage == null ? 0 : this.baseImage.hashCode());
                this.hashCode = result = 31 * result + this.decorationHandleIds.hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DecoratedImageKey)) {
                return false;
            }
            DecoratedImageKey other = (DecoratedImageKey)obj;
            return this.baseImage == other.baseImage && this.decorationHandleIds.equals(other.decorationHandleIds);
        }
    }

    public static final class DecorationHandle {
        private final String id;
        private ImageDescriptor imageDescriptor;
        private int quadrant;

        public DecorationHandle(String id, ImageDescriptor imageDescriptor, int quadrant) {
            if (id == null) {
                throw new IllegalArgumentException("Id cannot be null");
            }
            if (imageDescriptor == null) {
                throw new IllegalArgumentException("ImageDescriptor cannot be null");
            }
            if (quadrant != 2 && quadrant != 3 && quadrant != 0 && quadrant != 1 && quadrant != 4) {
                throw new IllegalArgumentException("Quadrand must be one of the constants specified in IDecoration");
            }
            this.id = id;
            this.imageDescriptor = imageDescriptor;
            this.quadrant = quadrant;
        }

        public void dispose() {
            this.imageDescriptor = null;
        }

        public String getId() {
            return this.id;
        }

        public ImageDescriptor getImageDescriptor() {
            return this.imageDescriptor;
        }

        public int getQuadrant() {
            return this.quadrant;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DecorationHandle)) {
                return false;
            }
            DecorationHandle other = (DecorationHandle)obj;
            return this.id.equals(other.id);
        }
    }
}

