/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;

public class DataControlObjectTreeFilter
extends PatternFilter {
    private IDataControlProvider dataControlProvider;
    private Collection<? extends IDataControlObject> filteredDataControlObjects;
    private Viewer viewer;
    private DTRTObjectUtil.IStringMatcher stringMatcher;

    public DataControlObjectTreeFilter() {
    }

    public DataControlObjectTreeFilter(IDataControlProvider dataControlProvider) {
        this.dataControlProvider = dataControlProvider;
    }

    public final void dispose() {
        if (this.filteredDataControlObjects != null) {
            this.filteredDataControlObjects.clear();
            this.filteredDataControlObjects = null;
        }
        this.dataControlProvider = null;
        this.viewer = null;
        this.stringMatcher = null;
    }

    public final Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        this.viewer = viewer;
        return super.filter(viewer, parent, elements);
    }

    public final boolean isElementVisible(Viewer viewer, Object element) {
        return element instanceof IDataControlObject ? this.filteredDataControlObjects != null && this.filteredDataControlObjects.contains(element) : super.isElementVisible(viewer, element);
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        return element instanceof IDataControlObject ? this.isElementVisible(viewer, element) && this.wordMatches(DTRTUtil.getLabel((IDescribable)((IDataControlObject)element))) : super.isLeafMatch(viewer, element);
    }

    public final void setPattern(String patternString) {
        super.setPattern(patternString);
        if (this.stringMatcher == null) {
            this.stringMatcher = new DTRTObjectUtil.IStringMatcher(){

                public boolean matches(String searchString, String string) {
                    return DataControlObjectTreeFilter.this.wordMatches(string);
                }
            };
        }
        try {
            this.filteredDataControlObjects = this.dataControlProvider != null ? DTRTObjectUtil.findByLabel((IDataControlProvider)this.dataControlProvider, (DTRTObjectUtil.IStringMatcher)this.stringMatcher, (String)patternString, null) : (this.viewer != null ? this.computeFilteredDataControlObjects(this.viewer.getInput(), patternString) : null);
        }
        catch (Exception exception) {
            this.filteredDataControlObjects = null;
        }
        super.setPattern(this.filteredDataControlObjects != null ? patternString : null);
    }

    protected Collection<? extends IDataControlObject> computeFilteredDataControlObjects(Object input, String patternString) throws Exception {
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            if (!collection.isEmpty() && collection.iterator().next() instanceof IDataControlObject) {
                return DTRTObjectUtil.findByLabel((Collection)collection, (DTRTObjectUtil.IStringMatcher)this.stringMatcher, (String)patternString, null);
            }
        } else if (input instanceof Object[]) {
            Object[] array = (Object[])input;
            if (array.length > 0 && array[0] instanceof IDataControlObject) {
                return DTRTObjectUtil.findByLabel(Arrays.asList(array), (DTRTObjectUtil.IStringMatcher)this.stringMatcher, (String)patternString, null);
            }
        } else {
            if (input instanceof IDataControlProvider) {
                return DTRTObjectUtil.findByLabel((IDataControlProvider)((IDataControlProvider)input), (DTRTObjectUtil.IStringMatcher)this.stringMatcher, (String)patternString, null);
            }
            if (input instanceof IDataControlObject) {
                return DTRTObjectUtil.findByLabel(Collections.singleton((IDataControlObject)input), (DTRTObjectUtil.IStringMatcher)this.stringMatcher, (String)patternString, null);
            }
        }
        return null;
    }
}

