/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.NotifyingTreeContentProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import org.eclipse.jface.viewers.Viewer;

public class StructureObjectContentProvider
extends NotifyingTreeContentProvider<IStructureObject> {
    @Override
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        Object[] array;
        if (inputElement instanceof IStructureObject) {
            return new Object[]{inputElement};
        }
        if (inputElement instanceof IDataControlProvider) {
            return ((IDataControlProvider)inputElement).getLoadedStructures().toArray();
        }
        if (inputElement instanceof Collection) {
            Collection collection = (Collection)inputElement;
            if (!collection.isEmpty()) {
                ArrayList<IStructureObject> structureObjects = new ArrayList<IStructureObject>(collection.size());
                for (Object object : collection) {
                    if (!(object instanceof IStructureObject)) continue;
                    structureObjects.add((IStructureObject)object);
                }
                return structureObjects.toArray();
            }
        } else if (inputElement instanceof Object[] && (array = (Object[])inputElement).length > 0) {
            ArrayList<IStructureObject> structureObjects = new ArrayList<IStructureObject>(array.length);
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IStructureObject) {
                    structureObjects.add((IStructureObject)object);
                }
                ++n2;
            }
            return array;
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return element instanceof IStructureObject ? ((IStructureObject)element).getParent() : null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IStructureObject) {
            IStructureObject structureObject = (IStructureObject)element;
            this.notifyHasChildren(structureObject);
            return !structureObject.getChildren().isEmpty();
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IStructureObject) {
            IStructureObject structureObject = (IStructureObject)parentElement;
            this.notifyGetChildren(structureObject);
            return structureObject.getChildren().toArray();
        }
        return DTRTUtil.EMPTY_ARRAY;
    }
}

