/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IBinding;
import oracle.eclipse.tools.adf.dtrt.object.IDataControl;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IExecutable;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Tree;

public class PageDefinitionContextContentProvider
implements ITreeContentProvider {
    private List<Category> categories;
    private IPageDefinitionContext context;

    public static DescribableTreeElement findObjectTreeElement(TreeViewer viewer, IObject object) {
        List<Category> categories;
        IContentProvider contentProvider;
        Tree tree;
        if (viewer != null && object instanceof IDataControlObject && !(tree = viewer.getTree()).isDisposed() && (contentProvider = viewer.getContentProvider()) instanceof PageDefinitionContextContentProvider && (categories = ((PageDefinitionContextContentProvider)contentProvider).categories) != null) {
            Category dataControlObjectCategory = null;
            for (Category category : categories) {
                if (IDataControlObject.class != category.getType()) continue;
                dataControlObjectCategory = category;
                break;
            }
            if (dataControlObjectCategory != null) {
                List<DescribableTreeElement> objectTreeElements = PageDefinitionContextContentProvider.computeUsedDataControlObjectElements(dataControlObjectCategory, Collections.singletonList((IDataControlObject)object));
                return PageDefinitionContextContentProvider.find(objectTreeElements, object);
            }
        }
        return null;
    }

    private static DescribableTreeElement find(List<?> elements, Object object) {
        for (Object element : elements) {
            if (!(element instanceof DescribableTreeElement)) continue;
            DescribableTreeElement objectTreeElement = (DescribableTreeElement)element;
            if (objectTreeElement.getDescribable() == object) {
                return objectTreeElement;
            }
            DescribableTreeElement child = PageDefinitionContextContentProvider.find(objectTreeElement.getChildren(), object);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private static List<DescribableTreeElement> computeUsedDataControlObjectElements(Category category, List<? extends IDataControlObject> dataControlObjects) {
        if (!dataControlObjects.isEmpty()) {
            LinkedHashMap<IDataControlObject, DescribableTreeElement> map = new LinkedHashMap<IDataControlObject, DescribableTreeElement>(dataControlObjects.size());
            for (IDataControlObject iDataControlObject : dataControlObjects) {
                PageDefinitionContextContentProvider.createObjectTreeElement(map, category, iDataControlObject);
            }
            ArrayList<DescribableTreeElement> arrayList = new ArrayList<DescribableTreeElement>();
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getKey() instanceof IDataControl)) continue;
                arrayList.add((DescribableTreeElement)entry.getValue());
            }
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    private static DescribableTreeElement createObjectTreeElement(Map<IDataControlObject, DescribableTreeElement> map, Category category, IDataControlObject dataControlObject) {
        DescribableTreeElement element = map.get(dataControlObject);
        if (element == null) {
            if (dataControlObject instanceof IDataControl) {
                element = new DescribableTreeElement(category, (IDescribable)dataControlObject);
            } else {
                IDataControlObject parent = dataControlObject.getParent();
                DescribableTreeElement parentElement = PageDefinitionContextContentProvider.createObjectTreeElement(map, category, parent);
                assert (parentElement != null);
                element = new DescribableTreeElement(parentElement, (IDescribable)dataControlObject);
                parentElement.addChild(element);
            }
            map.put(dataControlObject, element);
        }
        return element;
    }

    public void dispose() {
        if (this.categories != null) {
            this.categories.clear();
            this.categories = null;
        }
        this.context = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.initialize(newInput);
    }

    public Object[] getElements(Object inputElement) {
        if (this.context == null) {
            this.initialize(inputElement);
        }
        return this.categories != null ? this.categories.toArray() : DTRTUtil.EMPTY_ARRAY;
    }

    private void initialize(Object input) {
        if (input instanceof IPageDefinitionContext) {
            if (this.categories == null) {
                this.categories = new ArrayList<Category>(3);
                this.categories.add(new Category(IBinding.class, 1));
                this.categories.add(new Category(IExecutable.class, 2));
                this.categories.add(new Category(IDataControlObject.class, 3));
            }
            this.context = (IPageDefinitionContext)input;
        } else {
            this.categories = null;
        }
    }

    public Object getParent(Object element) {
        return this.categories == null ? null : (element instanceof IExecutable ? this.categories.get(1) : (element instanceof IBinding ? this.categories.get(0) : (element instanceof DescribableTreeElement ? ((DescribableTreeElement)element).getParent() : null)));
    }

    public boolean hasChildren(Object element) {
        return element instanceof Category ? ((Category)element).hasChildren() : (element instanceof DescribableTreeElement ? !((DescribableTreeElement)element).getChildren().isEmpty() : false);
    }

    public Object[] getChildren(Object parentElement) {
        return parentElement instanceof Category ? ((Category)parentElement).getChildren().toArray() : (parentElement instanceof DescribableTreeElement ? ((DescribableTreeElement)parentElement).getChildren().toArray() : DTRTUtil.EMPTY_ARRAY);
    }

    public final class Category
    extends BaseDescribable
    implements Comparable<Category> {
        private Class<? extends IObject> type;
        private int index;

        Category(Class<? extends IObject> type, int index) {
            this.type = type;
            this.index = index;
        }

        public Class<? extends IObject> getType() {
            return this.type;
        }

        protected BaseDescriptor createDescriptor() {
            return new BaseDescriptor(){

                public String getLabel() {
                    return Category.this.type == IBinding.class ? Messages.bindingCategoryLabel : (Category.this.type == IExecutable.class ? Messages.executableCategoryLabel : (Category.this.type == IDataControlObject.class ? Messages.dataControlCategoryLabel : ""));
                }

                public ImageManager.IImageData getImageData() {
                    return ImageManager.getInstance().getWorkbenchSharedImageData("IMG_OBJ_FOLDER");
                }
            };
        }

        public boolean hasChildren() {
            IPageDefinition pageDefinition = PageDefinitionContextContentProvider.this.context.getPageDefinition();
            return this.type == IBinding.class ? !pageDefinition.getBindings().isEmpty() : (this.type == IExecutable.class ? !pageDefinition.getExecutables().isEmpty() : (this.type == IDataControlObject.class ? !pageDefinition.getUsedDataControlObjects().isEmpty() : false));
        }

        public List<?> getChildren() {
            IPageDefinition pageDefinition = PageDefinitionContextContentProvider.this.context.getPageDefinition();
            return this.type == IBinding.class ? pageDefinition.getBindings() : (this.type == IExecutable.class ? pageDefinition.getExecutables() : (this.type == IDataControlObject.class ? PageDefinitionContextContentProvider.computeUsedDataControlObjectElements(this, pageDefinition.getUsedDataControlObjects()) : Collections.emptyList()));
        }

        @Override
        public int compareTo(Category o) {
            return this.index - o.index;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.index;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Category)) {
                return false;
            }
            Category other = (Category)obj;
            return this.index == other.index && this.type == other.type;
        }

        private PageDefinitionContextContentProvider getOuterType() {
            return PageDefinitionContextContentProvider.this;
        }
    }

    private static class Messages
    extends NLS {
        public static String bindingCategoryLabel;
        public static String executableCategoryLabel;
        public static String dataControlCategoryLabel;

        static {
            NLS.initializeMessages((String)PageDefinitionContextContentProvider.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }
}

