/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DecoratedImageManager;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ObjectLabelProvider
extends DescribableLabelProvider {
    private static DecoratedImageManager.DecorationHandle validationErrorHandle;
    private static DecoratedImageManager.DecorationHandle validationWarningHandle;
    private Map<? extends IObject, IStatus> validationMap;
    private DecoratedImageManager decoratedImageManager;

    protected static DecoratedImageManager.DecorationHandle getValidationErrorHandle() {
        Image decorationImage;
        if (validationErrorHandle == null && (decorationImage = DTRTUIUtil.getImage(ImageManager.getInstance().getWorkbenchSharedImageData("IMG_DEC_FIELD_ERROR"))) != null) {
            validationErrorHandle = new DecoratedImageManager.DecorationHandle("validationErrorDecoration", ImageDescriptor.createFromImage((Image)decorationImage), 2);
        }
        return validationErrorHandle;
    }

    protected static DecoratedImageManager.DecorationHandle getValidationWarningHandle() {
        Image decorationImage;
        if (validationWarningHandle == null && (decorationImage = DTRTUIUtil.getImage(ImageManager.getInstance().getWorkbenchSharedImageData("IMG_DEC_FIELD_WARNING"))) != null) {
            validationWarningHandle = new DecoratedImageManager.DecorationHandle("validationWarningDecoration", ImageDescriptor.createFromImage((Image)decorationImage), 2);
        }
        return validationWarningHandle;
    }

    @Override
    public void dispose() {
        if (this.decoratedImageManager != null) {
            this.decoratedImageManager.dispose();
            this.decoratedImageManager = null;
        }
        this.validationMap = null;
        super.dispose();
    }

    public ObjectLabelProvider setValidationMap(Map<? extends IObject, IStatus> validationMap) {
        this.validationMap = validationMap;
        return this;
    }

    public Map<? extends IObject, IStatus> getValidationMap() {
        return this.validationMap;
    }

    @Override
    public String getToolTipText(Object element) {
        IStatus status;
        if (element instanceof IObject && this.getValidationMap() != null && (status = this.getValidationMap().get(element)) != null) {
            StringBuilder sb = new StringBuilder();
            this.appendMessage(sb, status);
            if (status.isMultiStatus()) {
                this.appendChildrenMessage(sb, status);
            }
            return sb.toString();
        }
        return super.getToolTipText(element);
    }

    private void appendChildrenMessage(StringBuilder sb, IStatus status) {
        if (status != null) {
            if (status.isMultiStatus()) {
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    this.appendChildrenMessage(sb, child);
                    ++n2;
                }
            } else {
                this.appendMessage(sb.append("\n -"), status);
            }
        }
    }

    private void appendMessage(StringBuilder sb, IStatus status) {
        String message;
        if (status != null && !DTRTUtil.isEmpty((String)(message = status.getMessage()))) {
            sb.append(message);
        }
    }

    public Image getToolTipImage(Object object) {
        return object instanceof IObject && this.getValidationMap() != null && this.getValidationMap().containsKey(object) ? DTRTUIUtil.getImage(ImageManager.getInstance().getWorkbenchSharedImageData(this.getValidationMap().get(object).getSeverity() == 4 ? "IMG_OBJS_ERROR_TSK" : "IMG_OBJS_WARN_TSK")) : super.getToolTipImage(object);
    }

    @Override
    public Image getImage(Object element) {
        Image image = DTRTUIUtil.getImage(this.getDescriptor(element));
        if (image != null && element instanceof IObject) {
            image = this.decorateImage((IObject)element, image);
        }
        return image;
    }

    protected DecoratedImageManager getDecoratedImageManager() {
        return this.decoratedImageManager == null ? (this.decoratedImageManager = new DecoratedImageManager()) : this.decoratedImageManager;
    }

    protected Image decorateImage(IObject object, Image image) {
        List<DecoratedImageManager.DecorationHandle> decorationHandles = this.computeDecorationHandles(object);
        return decorationHandles.isEmpty() ? image : this.getDecoratedImageManager().decorate(image, decorationHandles);
    }

    protected List<DecoratedImageManager.DecorationHandle> computeDecorationHandles(IObject object) {
        IStatus status;
        ArrayList<DecoratedImageManager.DecorationHandle> decorationHandles = new ArrayList<DecoratedImageManager.DecorationHandle>(5);
        if (this.getValidationMap() != null && (status = this.getValidationMap().get(object)) != null) {
            DecoratedImageManager.DecorationHandle decorator = null;
            if (status.getSeverity() == 4) {
                decorator = ObjectLabelProvider.getValidationErrorHandle();
            } else if (status.getSeverity() == 2) {
                decorator = ObjectLabelProvider.getValidationWarningHandle();
            }
            if (decorator != null) {
                decorationHandles.add(decorator);
            }
        }
        return decorationHandles;
    }
}

