/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;

public class ObjectContentProvider
implements ITreeContentProvider {
    private boolean useNullTypeDescriptor;
    private Map<Object, List<IObject>> elementChildrenMap;
    private Class<? extends IObject> objectType;
    private Comparator<Object> elementComparator;
    private Comparator<? super IObject> childObjectComparator;

    public ObjectContentProvider() {
        this.objectType = IObject.class;
    }

    public ObjectContentProvider(Class<? extends IObject> objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("Object type cannot be null");
        }
        this.objectType = objectType;
    }

    public void dispose() {
        if (this.elementChildrenMap != null) {
            this.elementChildrenMap.clear();
            this.elementChildrenMap = null;
        }
        this.elementComparator = null;
        this.childObjectComparator = null;
    }

    public void setUseNullTypeDescriptor(boolean useNullTypeDescriptor) {
        this.useNullTypeDescriptor = useNullTypeDescriptor;
    }

    public boolean isUseNullTypeDescriptor() {
        return this.useNullTypeDescriptor;
    }

    public void setElementComparator(Comparator<Object> elementComparator) {
        this.elementComparator = elementComparator;
    }

    public Comparator<Object> getElementComparator() {
        return this.elementComparator;
    }

    public void setChildObjectComparator(Comparator<? super IObject> childObjectComparator) {
        this.childObjectComparator = childObjectComparator;
    }

    public Comparator<? super IObject> getChildObjectComparator() {
        return this.childObjectComparator;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.initialize(newInput);
    }

    public final Object[] getElements(Object inputElement) {
        if (this.elementChildrenMap == null) {
            this.initialize(inputElement);
        }
        return this.elementChildrenMap != null ? this.elementChildrenMap.keySet().toArray() : DTRTUtil.EMPTY_ARRAY;
    }

    private void initialize(Object input) {
        this.elementChildrenMap = null;
        Collection<Object> inputCollection = input instanceof Collection ? (List<Object>)input : (input instanceof Object[] ? Arrays.asList((Object[])input) : (input instanceof IObject ? Collections.singleton(input) : null));
        if (inputCollection != null) {
            ArrayList<IObject> inputObjects = new ArrayList<IObject>(inputCollection.size());
            for (Object o : inputCollection) {
                if (o == null || !this.isValidObject(this.objectType, o)) continue;
                inputObjects.add((IObject)o);
            }
            if (!inputObjects.isEmpty()) {
                boolean useNullTypeDescriptor = this.isUseNullTypeDescriptor();
                NullTypeDescriptor nullTypeDescriptor = null;
                ArrayList<Object> elements = new ArrayList<Object>(inputObjects.size());
                HashMap<Object, ArrayList<IObject>> map = new HashMap<Object, ArrayList<IObject>>(inputObjects.size());
                for (IObject iObject : inputObjects) {
                    ArrayList<IObject> list;
                    IDescriptor typeDescriptor = iObject.getTypeDescriptor();
                    if (typeDescriptor == null) {
                        if (useNullTypeDescriptor) {
                            if (nullTypeDescriptor == null) {
                                nullTypeDescriptor = new NullTypeDescriptor();
                            }
                            typeDescriptor = nullTypeDescriptor;
                        } else {
                            map.put(iObject, null);
                            elements.add(iObject);
                            continue;
                        }
                    }
                    if ((list = (ArrayList<IObject>)map.get(typeDescriptor)) == null) {
                        list = new ArrayList<IObject>();
                        map.put(typeDescriptor, list);
                        elements.add(typeDescriptor);
                    }
                    list.add(iObject);
                }
                this.sortElements(elements);
                this.elementChildrenMap = new LinkedHashMap<Object, List<IObject>>(map.size());
                for (Object e : elements) {
                    List list = (List)map.get(e);
                    if (list != null && !list.isEmpty()) {
                        Collections.sort(list);
                        this.elementChildrenMap.put(e, list);
                        continue;
                    }
                    this.elementChildrenMap.put(e, null);
                }
            }
        }
    }

    public final IDescriptor getParent(Object element) {
        IDescriptor typeDescriptor;
        if (this.elementChildrenMap != null && element instanceof IObject && this.elementChildrenMap.containsKey(typeDescriptor = ((IObject)element).getTypeDescriptor())) {
            return typeDescriptor;
        }
        return null;
    }

    public final boolean hasChildren(Object element) {
        if (this.elementChildrenMap != null) {
            List<IObject> list = this.elementChildrenMap.get(element);
            return list != null;
        }
        return false;
    }

    public final IObject[] getChildren(Object parentElement) {
        List<IObject> list;
        if (this.elementChildrenMap != null && (list = this.elementChildrenMap.get(parentElement)) != null) {
            return list.toArray(new IObject[list.size()]);
        }
        return new IObject[0];
    }

    protected boolean isValidObject(Class<? extends IObject> objectType, Object o) {
        return objectType.isInstance(o);
    }

    protected void sortElements(List<Object> elements) {
        Comparator<Object> comparator = this.getElementComparator();
        if (comparator != null) {
            Collections.sort(elements, comparator);
        }
    }

    protected void sortChildObjects(Object parent, List<IObject> objects) {
        Comparator<? super IObject> comparator = this.getChildObjectComparator();
        if (comparator != null) {
            Collections.sort(objects, comparator);
        }
    }

    private static class Messages
    extends NLS {
        public static String nullTypeDescriptorLabel;

        static {
            NLS.initializeMessages((String)ObjectContentProvider.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    public static class NullTypeDescriptor
    extends BaseDescriptor {
        public String getLabel() {
            return Messages.nullTypeDescriptorLabel;
        }
    }
}

