/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.jface.viewers.ITreeContentProvider;

public abstract class NotifyingTreeContentProvider<P>
implements ITreeContentProvider {
    private TypedListenerList<ITreeContentProviderListener<P>> listeners;

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public final void addListener(ITreeContentProviderListener<P> listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new TypedListenerList();
            }
            this.listeners.add(listener);
        }
    }

    public final void removeListener(ITreeContentProviderListener<P> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    protected final void notifyHasChildren(P parent) {
        if (this.listeners != null) {
            for (ITreeContentProviderListener listener : this.listeners) {
                try {
                    listener.handleHasChildren(parent);
                }
                catch (Exception exception) {}
            }
        }
    }

    protected final void notifyGetChildren(P parent) {
        if (this.listeners != null) {
            for (ITreeContentProviderListener listener : this.listeners) {
                try {
                    listener.handleGetChildren(parent);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static interface ITreeContentProviderListener<P> {
        public void handleHasChildren(P var1);

        public void handleGetChildren(P var1);
    }
}

