/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableFolder;
import oracle.eclipse.tools.adf.dtrt.ui.util.BaseMenuCreator;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableJavaElement;
import oracle.eclipse.tools.adf.dtrt.ui.util.DescribableTreeElement;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DescribableResource;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;

public abstract class LayoutContentProvider
implements ITreeContentProvider {
    private static final Object LOCAL_DESCRIBABLE_TREE_ELEMENT_DATA = "From LayoutContentProvider - " + LayoutContentProvider.class.hashCode();
    private Layout layout = Layout.UNCATEGORIZED;
    private Map<Object, DescribableTreeElement> parentMap;
    private Viewer viewer;
    private TypedListenerList<ILayoutChangeListener> listeners = new TypedListenerList();
    private IProject mainProject;
    private Map<DescribableTreeElement, DescribableTreeElement> describableTreeElementMap;
    private IStructuredContentProvider contentProvider;

    public static int getNumberOfChildren(Object container) {
        return container instanceof DescribableTreeElement ? LayoutContentProvider.getNumberOfChildren((DescribableTreeElement)container) : -1;
    }

    private static int getNumberOfChildren(DescribableTreeElement container) {
        int number = 0;
        for (Object child : container.getChildren()) {
            if (child instanceof DescribableTreeElement) {
                number += LayoutContentProvider.getNumberOfChildren((DescribableTreeElement)child);
                continue;
            }
            if (child == null) continue;
            ++number;
        }
        return number;
    }

    private static boolean isLocalDescribableTreeElement(Object element) {
        return element instanceof DescribableTreeElement && LOCAL_DESCRIBABLE_TREE_ELEMENT_DATA.equals(((DescribableTreeElement)element).getData());
    }

    public LayoutContentProvider() {
    }

    public LayoutContentProvider(IStructuredContentProvider contentProvider) {
        this();
        this.contentProvider = contentProvider;
    }

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
            this.contentProvider = null;
        }
        if (this.describableTreeElementMap != null) {
            DTRTUtil.dispose(this.describableTreeElementMap.values());
            this.describableTreeElementMap.clear();
            this.describableTreeElementMap = null;
        }
        this.reset();
        this.viewer = null;
        this.mainProject = null;
    }

    private void reset() {
        if (this.parentMap != null) {
            this.parentMap.clear();
            this.parentMap = null;
        }
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public final IAction createLayoutAction() {
        Action layoutAction = new Action("", 4){

            public void run() {
                int index;
                Layout layout = LayoutContentProvider.this.getLayout();
                Layout[] values = Layout.values();
                do {
                    if ((index = layout.ordinal()) < values.length - 1) {
                        ++index;
                        continue;
                    }
                    index = 0;
                } while ((layout = values[index]) != LayoutContentProvider.this.getLayout() && !LayoutContentProvider.this.isSupportedLayout(layout));
                LayoutContentProvider.this.setLayout(layout);
                this.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage(LayoutContentProvider.this.getLayout().getImageData())));
            }
        };
        BaseMenuCreator menuCreator = new BaseMenuCreator((IAction)layoutAction){
            private final /* synthetic */ IAction val$layoutAction;
            {
                this.val$layoutAction = iAction;
            }

            @Override
            protected void initializeMenu(Menu menu) {
                Layout[] layoutArray = Layout.values();
                int n = layoutArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Layout layout = layoutArray[n2];
                    if (LayoutContentProvider.this.isSupportedLayout(layout)) {
                        SetLayoutAction action = new SetLayoutAction(layout, this.val$layoutAction);
                        if (layout == LayoutContentProvider.this.getLayout()) {
                            action.setChecked(true);
                            this.val$layoutAction.setImageDescriptor(action.getImageDescriptor());
                        }
                        ActionContributionItem item = new ActionContributionItem((IAction)action);
                        item.fill(menu, -1);
                    }
                    ++n2;
                }
            }
        };
        layoutAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage(this.getLayout().getImageData())));
        layoutAction.setToolTipText(Messages.selectLayout);
        layoutAction.setMenuCreator((IMenuCreator)menuCreator);
        return layoutAction;
    }

    public final Viewer getViewer() {
        return this.viewer;
    }

    public final void setMainProject(IProject mainProject) {
        this.mainProject = mainProject;
    }

    public final IProject getMainProject() {
        return this.mainProject;
    }

    public final void addLayoutChangeListener(ILayoutChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public final void removeLayoutChangeListener(ILayoutChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public final void setLayout(Layout layout) {
        if (this.layout != layout) {
            if (!this.isSupportedLayout(layout)) {
                throw new IllegalArgumentException("Unsupported layout: " + (Object)((Object)layout));
            }
            this.layout = layout;
            this.reset();
            for (ILayoutChangeListener listener : this.listeners) {
                listener.handleLayoutChange(this, this.viewer);
            }
        }
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.getContentProvider() != null) {
            this.getContentProvider().inputChanged(viewer, oldInput, newInput);
        }
    }

    public final Object[] getElements(Object inputElement) {
        this.reset();
        switch (this.getLayout()) {
            case UNCATEGORIZED: {
                return this.computeUncategorizedTree();
            }
            case BY_JAVA_TYPE: 
            case BY_DECLARATION: {
                return this.computeTree();
            }
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    public final Object getParent(Object element) {
        DescribableTreeElement parent;
        if (this.parentMap != null && (parent = this.parentMap.get(element)) != null) {
            return parent;
        }
        return LayoutContentProvider.isLocalDescribableTreeElement(element) ? ((DescribableTreeElement)element).getParent() : (element != null ? this.doGetParent(element) : null);
    }

    public final boolean hasChildren(Object element) {
        return LayoutContentProvider.isLocalDescribableTreeElement(element) ? !((DescribableTreeElement)element).getChildren().isEmpty() : (element != null ? this.doHasChildren(element) : false);
    }

    public final Object[] getChildren(Object parentElement) {
        return LayoutContentProvider.isLocalDescribableTreeElement(parentElement) ? ((DescribableTreeElement)parentElement).getChildren().toArray() : (parentElement != null ? this.doGetChildren(parentElement) : DTRTUtil.EMPTY_ARRAY);
    }

    protected Object[] getRootObjects() {
        Object[] rootObjects;
        if (this.getContentProvider() != null && (rootObjects = this.getContentProvider().getElements(this.viewer.getInput())) != null) {
            return rootObjects;
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    protected Object doGetParent(Object object) {
        return this.getContentProvider() instanceof ITreeContentProvider ? ((ITreeContentProvider)this.getContentProvider()).getParent(object) : null;
    }

    protected boolean doHasChildren(Object object) {
        return this.getContentProvider() instanceof ITreeContentProvider && ((ITreeContentProvider)this.getContentProvider()).hasChildren(object);
    }

    protected Object[] doGetChildren(Object object) {
        return this.getContentProvider() instanceof ITreeContentProvider ? ((ITreeContentProvider)this.getContentProvider()).getChildren(object) : null;
    }

    protected abstract boolean isSupportedLayout(Layout var1);

    protected abstract String getUncategorizedFolderLabel();

    protected abstract IType getType(Object var1);

    protected abstract IFile getDeclarationFile(Object var1);

    private void addChildren(DescribableTreeElement element, Object[] objects) {
        if (objects.length > 0) {
            if (this.parentMap == null) {
                this.parentMap = new HashMap<Object, DescribableTreeElement>(objects.length);
            }
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                element.addChild(object);
                this.parentMap.put(object, element);
                ++n2;
            }
        }
    }

    private Object[] computeUncategorizedTree() {
        Object[] rootObjects = this.getRootObjects();
        if (rootObjects.length > 0) {
            this.parentMap = new HashMap<Object, DescribableTreeElement>(rootObjects.length);
            DescribableTreeElement element = this.createDescribableTreeElement((IDescribable)new DescribableFolder(this.getUncategorizedFolderLabel()));
            this.addChildren(element, rootObjects);
            return new Object[]{element};
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    private Object[] computeTree() {
        Object[] rootObjects = this.getRootObjects();
        if (rootObjects.length > 0) {
            HashMap<IType, List<Object>> objectMap = new HashMap<IType, List<Object>>(rootObjects.length);
            ArrayList<Object> notMapped = new ArrayList<Object>();
            Object[] objectArray = rootObjects;
            int n = rootObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IType key = null;
                switch (this.getLayout()) {
                    case BY_JAVA_TYPE: {
                        key = this.getType(object);
                        break;
                    }
                    case BY_DECLARATION: {
                        key = this.getDeclarationFile(object);
                    }
                }
                if (key != null) {
                    ArrayList<Object> list = (ArrayList<Object>)objectMap.get(key);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        objectMap.put(key, list);
                    }
                    list.add(object);
                } else {
                    notMapped.add(object);
                }
                ++n2;
            }
            this.parentMap = new HashMap<Object, DescribableTreeElement>(rootObjects.length);
            ArrayList<Object> rootElements = new ArrayList<Object>();
            if (!objectMap.isEmpty()) {
                LinkedHashMap<IProject, DescribableTreeElement> rootElementMap = new LinkedHashMap<IProject, DescribableTreeElement>();
                switch (this.getLayout()) {
                    case BY_JAVA_TYPE: {
                        HashMap<IType, List<Object>> map = objectMap;
                        this.computeJavaTree(rootElementMap, map);
                        break;
                    }
                    case BY_DECLARATION: {
                        HashMap<IType, List<Object>> map = objectMap;
                        this.computeDeclarationTree(rootElementMap, map);
                    }
                }
                DescribableTreeElement element = (DescribableTreeElement)rootElementMap.get(this.getMainProject());
                if (element != null) {
                    element.setCategory(100);
                }
                rootElements.addAll(rootElementMap.values());
            }
            if (!notMapped.isEmpty()) {
                DescribableFolder describableFolder = null;
                switch (this.getLayout()) {
                    case BY_JAVA_TYPE: {
                        describableFolder = new DescribableFolder(Messages.notInTypeLabel, Messages.notInTypeToolTip);
                        break;
                    }
                    case BY_DECLARATION: {
                        describableFolder = new DescribableFolder(Messages.notInFileLabel, Messages.notInFileToolTip);
                    }
                }
                DescribableTreeElement element = this.createDescribableTreeElement((IDescribable)describableFolder);
                rootElements.add(element);
                element.setCategory(200);
                if (!notMapped.isEmpty()) {
                    this.addChildren(element, notMapped.toArray());
                }
            }
            return rootElements.toArray();
        }
        return DTRTUtil.EMPTY_ARRAY;
    }

    private void computeDeclarationTree(Map<IProject, DescribableTreeElement> rootElementMap, Map<IFile, List<Object>> fileMap) {
        HashMap<IResource, DescribableTreeElement> treeElementMap = new HashMap<IResource, DescribableTreeElement>();
        for (Map.Entry<IFile, List<Object>> entry : fileMap.entrySet()) {
            DescribableTreeElement element = this.computeDeclarationTree(treeElementMap, rootElementMap, (IResource)entry.getKey());
            assert (element != null) : entry.getKey();
            this.addChildren(element, entry.getValue().toArray());
        }
    }

    private DescribableTreeElement computeDeclarationTree(Map<IResource, DescribableTreeElement> map, Map<IProject, DescribableTreeElement> rootElementMap, IResource resource) {
        if (resource != null) {
            DescribableTreeElement element = map.get(resource);
            if (element == null) {
                switch (resource.getType()) {
                    case 1: 
                    case 2: {
                        DescribableTreeElement parentElement = this.computeDeclarationTree(map, rootElementMap, (IResource)resource.getParent());
                        if (parentElement == null) break;
                        element = this.createDescribableTreeElement(parentElement, (IDescribable)new DescribableResource(resource));
                        parentElement.addChild(element);
                        break;
                    }
                    case 4: {
                        element = this.createDescribableTreeElement((IDescribable)new DescribableResource(resource));
                        rootElementMap.put((IProject)resource, element);
                    }
                }
            }
            if (element != null) {
                map.put(resource, element);
                return element;
            }
        }
        return null;
    }

    private void computeJavaTree(Map<IProject, DescribableTreeElement> rootElementMap, Map<IType, List<Object>> typeMap) {
        HashMap<IJavaElement, DescribableTreeElement> treeElementMap = new HashMap<IJavaElement, DescribableTreeElement>();
        StandardJavaElementContentProvider javaContentProvider = new StandardJavaElementContentProvider(true);
        for (Map.Entry<IType, List<Object>> entry : typeMap.entrySet()) {
            ArrayList<IJavaElement> parents = new ArrayList<IJavaElement>();
            Object parent = javaContentProvider.getParent((Object)entry.getKey());
            while (parent instanceof IJavaElement && !(parent instanceof IJavaModel)) {
                parents.add((IJavaElement)parent);
                parent = javaContentProvider.getParent(parent);
            }
            parent = null;
            int i = parents.size() - 1;
            while (i >= 0) {
                IJavaElement javaElement = (IJavaElement)parents.get(i);
                DescribableTreeElement element = (DescribableTreeElement)treeElementMap.get(javaElement);
                if (element == null) {
                    if (parent == null) {
                        IProject project = ((IJavaProject)javaElement).getProject();
                        element = this.createDescribableTreeElement((IDescribable)new DescribableResource((IResource)project));
                        rootElementMap.put(project, element);
                    } else {
                        element = this.createDescribableTreeElement(parent, (IDescribable)new DescribableJavaElement(javaElement, !(javaElement instanceof IPackageFragment)));
                        ((DescribableTreeElement)parent).addChild(element);
                    }
                    treeElementMap.put(javaElement, element);
                }
                parent = element;
                --i;
            }
            if (parent == null) {
                throw new IllegalStateException("Unable to determine the parent of " + entry.getKey());
            }
            DescribableTreeElement typeElement = this.createDescribableTreeElement(parent, (IDescribable)new DescribableJavaElement((IJavaElement)entry.getKey(), true));
            ((DescribableTreeElement)parent).addChild(typeElement);
            this.addChildren(typeElement, entry.getValue().toArray());
        }
    }

    private DescribableTreeElement createDescribableTreeElement(IDescribable describable) {
        return this.createDescribableTreeElement(null, describable);
    }

    private DescribableTreeElement createDescribableTreeElement(Object parent, IDescribable describable) {
        DescribableTreeElement describableTreeElement;
        DescribableTreeElement cached;
        if (this.describableTreeElementMap == null) {
            this.describableTreeElementMap = new HashMap<DescribableTreeElement, DescribableTreeElement>();
        }
        if ((cached = this.describableTreeElementMap.get(describableTreeElement = parent == null ? new DescribableTreeElement(describable) : new DescribableTreeElement(parent, describable))) != null) {
            cached.clearChildren();
            describableTreeElement = cached;
        } else {
            describableTreeElement.setData(LOCAL_DESCRIBABLE_TREE_ELEMENT_DATA);
            this.describableTreeElementMap.put(describableTreeElement, describableTreeElement);
        }
        return describableTreeElement;
    }

    public static interface ILayoutChangeListener {
        public void handleLayoutChange(LayoutContentProvider var1, Viewer var2);
    }

    public static enum Layout {
        UNCATEGORIZED(Messages.layoutUncategorized, (ImageManager.IImageData)DTRTBundleIcon.ACTION_LAYOUT_NONE),
        BY_JAVA_TYPE(Messages.layoutJava, (ImageManager.IImageData)DTRTBundleIcon.ACTION_LAYOUT_JAVA),
        BY_DECLARATION(Messages.layoutDeclaration, (ImageManager.IImageData)DTRTBundleIcon.ACTION_LAYOUT_FILE);

        private String label;
        private ImageManager.IImageData imageData;

        private Layout(String label, ImageManager.IImageData imageData) {
            this.label = label;
            this.imageData = imageData;
        }

        public String getLabel() {
            return this.label;
        }

        public ImageManager.IImageData getImageData() {
            return this.imageData;
        }
    }

    private static class Messages
    extends NLS {
        public static String layoutUncategorized;
        public static String layoutJava;
        public static String layoutDeclaration;
        public static String selectLayout;
        public static String notInFileLabel;
        public static String notInFileToolTip;
        public static String notInTypeLabel;
        public static String notInTypeToolTip;

        static {
            NLS.initializeMessages((String)LayoutContentProvider.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private class SetLayoutAction
    extends Action {
        private Layout layout;
        private IAction layoutAction;

        public SetLayoutAction(Layout layout, IAction layoutAction) {
            super(layout.getLabel(), 8);
            this.layout = layout;
            this.layoutAction = layoutAction;
            this.setId("SetLayoutAction." + layout.getLabel());
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage(layout.getImageData())));
        }

        public void run() {
            LayoutContentProvider.this.setLayout(this.layout);
            this.layoutAction.setImageDescriptor(this.getImageDescriptor());
        }
    }
}

