/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.provider.IObjectContentProviderDelegate;
import org.eclipse.jface.viewers.Viewer;

public class DelegatingObjectContentProvider
implements IObjectContentProviderDelegate {
    private List<IObjectContentProviderDelegate> delegates = new ArrayList<IObjectContentProviderDelegate>(2);

    public DelegatingObjectContentProvider(IObjectContentProviderDelegate ... delegates) {
        this.delegates.addAll(Arrays.asList(delegates));
    }

    public void dispose() {
        if (this.delegates != null) {
            for (IObjectContentProviderDelegate delegate : this.delegates) {
                delegate.dispose();
            }
            this.delegates.clear();
            this.delegates = null;
        }
    }

    public void addDelegate(IObjectContentProviderDelegate delegate) {
        this.delegates.add(delegate);
    }

    public void removeDelegate(IObjectContentProviderDelegate delegate) {
        this.delegates.remove(delegate);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            IObjectContentProviderDelegate.ProvideType provideType = delegate.providesForProvideType(newInput);
            if (!provideType.isProvides()) continue;
            delegate.inputChanged(viewer, oldInput, newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            IObjectContentProviderDelegate.ProvideType provideType = delegate.providesForProvideType(inputElement);
            if (provideType.isProvides()) {
                elements.addAll(Arrays.asList(delegate.getElements(inputElement)));
            }
            if (provideType.isVetoes()) break;
        }
        return elements.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            IObjectContentProviderDelegate.ProvideType provideType = delegate.providesForProvideType(parentElement);
            if (provideType.isProvides()) {
                elements.addAll(Arrays.asList(delegate.getChildren(parentElement)));
            }
            if (provideType.isVetoes()) break;
        }
        return elements.toArray();
    }

    public Object getParent(Object element) {
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            IObjectContentProviderDelegate.ProvideType provideType = delegate.providesForProvideType(element);
            if (!provideType.isProvides()) continue;
            return delegate.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            IObjectContentProviderDelegate.ProvideType provideType = delegate.providesForProvideType(element);
            if (provideType.isProvides()) {
                hasChildren |= delegate.hasChildren(element);
            }
            if (provideType.isVetoes()) break;
        }
        return hasChildren;
    }

    @Override
    public IObjectContentProviderDelegate.ProvideType providesForProvideType(Object object) {
        IObjectContentProviderDelegate.ProvideType provideType = IObjectContentProviderDelegate.ProvideType.NO;
        for (IObjectContentProviderDelegate delegate : this.delegates) {
            provideType = delegate.providesForProvideType(object);
            if (provideType.isProvides()) {
                provideType = IObjectContentProviderDelegate.ProvideType.PROVIDE;
            }
            if (!provideType.isVetoes()) continue;
            provideType = IObjectContentProviderDelegate.ProvideType.PROVIDE_VETO;
            break;
        }
        return provideType;
    }
}

