/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.provider;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IDataControlObject;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IStructureChild;
import oracle.eclipse.tools.adf.dtrt.object.IStructureObject;
import oracle.eclipse.tools.adf.dtrt.ui.provider.ObjectLabelProvider;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.DecoratedImageManager;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CustomizedStructureObjectLabelProvider
extends ObjectLabelProvider {
    private static DecoratedImageManager.DecorationHandle customizationHandle;
    private static DecoratedImageManager.DecorationHandle extrinsicObjectHandle;

    private static DecoratedImageManager.DecorationHandle getCustomizationHandle() {
        Image decorationImage;
        if (customizationHandle == null && (decorationImage = DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.OVERLAY_EDIT)) != null) {
            customizationHandle = new DecoratedImageManager.DecorationHandle("customizedStructureObjectHandleDecoration", ImageDescriptor.createFromImage((Image)decorationImage), 1);
        }
        return customizationHandle;
    }

    private static DecoratedImageManager.DecorationHandle getExtrinsicHandle() {
        Image decorationImage;
        if (extrinsicObjectHandle == null && (decorationImage = DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.OVERLAY_PLUS)) != null) {
            extrinsicObjectHandle = new DecoratedImageManager.DecorationHandle("extrinsicStructureObjectHandleDecoration", ImageDescriptor.createFromImage((Image)decorationImage), 3);
        }
        return extrinsicObjectHandle;
    }

    @Override
    protected List<DecoratedImageManager.DecorationHandle> computeDecorationHandles(IObject object) {
        List<DecoratedImageManager.DecorationHandle> decorationHandles = super.computeDecorationHandles(object);
        if (object instanceof IDataControlObject) {
            object = ((IDataControlObject)object).getStructureObject();
        }
        if (object instanceof IStructureObject) {
            IStructureChild structureChild;
            if (((IStructureObject)object).isCustomized()) {
                decorationHandles.add(CustomizedStructureObjectLabelProvider.getCustomizationHandle());
            }
            if (object instanceof IStructureChild && (structureChild = (IStructureChild)object).getKind() == IStructureChild.StructureChildKind.EXTRINSIC) {
                decorationHandles.add(CustomizedStructureObjectLabelProvider.getExtrinsicHandle());
            }
        }
        return decorationHandles;
    }
}

