/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class JFaceImageManager
extends ImageManager {
    private ImageRegistry imageRegistry;
    private ISharedImages sharedImages;
    private ILabelProvider workbenchLabelProvider;
    private Map<String, ImageManager.IImageData> imageDataCache;

    private static InputStream toInputStream(Image image) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{image.getImageData()};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)baos, 5);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    protected synchronized ImageManager initialize() {
        if (this.imageRegistry == null && PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null) {
            ImageRegistry imageRegistry;
            this.imageRegistry = imageRegistry = this.createImageRegistry();
            this.sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
            this.imageDataCache = new HashMap<String, ImageManager.IImageData>();
        }
        return this.imageRegistry != null ? this : null;
    }

    protected void doDispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
        if (this.imageDataCache != null) {
            this.imageDataCache.clear();
            this.imageDataCache = null;
        }
        this.sharedImages = null;
        this.workbenchLabelProvider = null;
        super.doDispose();
    }

    private ImageRegistry createImageRegistry() {
        Display display = Display.getCurrent();
        if (display == null && (display = PlatformUI.getWorkbench().getDisplay()) == null) {
            throw new IllegalStateException();
        }
        return new ImageRegistry(display);
    }

    public ImageManager.IImageData getWorkbenchSharedImageData(String symbolicName) {
        if (this.imageDataCache != null && this.sharedImages != null && symbolicName != null) {
            ImageManager.IImageData data = this.imageDataCache.get(symbolicName);
            if (data == null) {
                Image image = this.sharedImages.getImage(symbolicName);
                if (image != null) {
                    data = new ImageDataImpl(image);
                } else if ("IMG_DEC_FIELD_ERROR".equals(symbolicName)) {
                    data = DTRTBundleIcon.OVERLAY_ERROR;
                } else if ("IMG_DEC_FIELD_WARNING".equals(symbolicName)) {
                    data = DTRTBundleIcon.OVERLAY_WARNING;
                }
                if (data != null) {
                    this.imageDataCache.put(symbolicName, data);
                }
            }
            return data;
        }
        return null;
    }

    public ImageManager.IImageData getWorkbenchImageData(Object object) {
        Image image;
        if (this.workbenchLabelProvider != null && object != null && (image = this.workbenchLabelProvider.getImage(object)) != null) {
            ImageDataImpl data = new ImageDataImpl(image);
            return data;
        }
        return null;
    }

    public ImageManager.IImageData getImageData(Object image) {
        return image instanceof Image ? new ImageDataImpl((Image)image) : (image instanceof ImageManager.IImageData ? (ImageManager.IImageData)image : null);
    }

    public Object getImage(ImageManager.IImageData imageData) {
        if (imageData != null) {
            String key = imageData.getKey();
            Image image = this.imageRegistry.get(key);
            if (image != null) {
                return image;
            }
            byte[] bytes = imageData.toBytes();
            if (bytes != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                this.imageRegistry.put(key, ImageDescriptor.createFromImageData((ImageData)new ImageData((InputStream)inputStream)));
                return this.imageRegistry.get(key);
            }
        }
        return null;
    }

    private static class ImageDataImpl
    implements ImageManager.IImageData {
        private String key;
        private Image image;

        public ImageDataImpl(Image image) {
            this.image = image;
            this.key = image.toString();
        }

        public String getKey() {
            return this.key;
        }

        public byte[] toBytes() {
            if (this.image != null) {
                if (this.image.isDisposed()) {
                    this.image = null;
                } else {
                    try {
                        return DTRTUtil.read((InputStream)JFaceImageManager.toInputStream(this.image));
                    }
                    catch (IOException e) {
                        DTRTUIBundle.log(e);
                    }
                }
            }
            return null;
        }
    }
}

