/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.internal;

import oracle.eclipse.tools.adf.dtrt.ui.internal.UIValidationPreferencesHelper;
import oracle.eclipse.tools.adf.dtrt.ui.util.PageDefinitionMarkerManager;
import oracle.eclipse.tools.adf.dtrt.ui.validation.ArtifactValidationPreferences;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ArtifactValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button _disableValidation;
    private Button _makeErrorsWarnings;
    private Button _runNow;
    private DataBindingContext _context;
    private ArtifactValidationPreferences _prefs = new ArtifactValidationPreferences(this.getPreferenceStore());
    private IPersistentPreferenceStore _preferenceStore;

    public ArtifactValidationPreferencePage() {
        this._prefs.load();
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        this._disableValidation = new Button(comp, 32);
        this._disableValidation.setText(Messages.LABEL_DISABLE_VALIDATION);
        this._makeErrorsWarnings = new Button(comp, 32);
        this._makeErrorsWarnings.setText(Messages.LABEL_REDUCE_SEVERITY);
        this._makeErrorsWarnings.setToolTipText(Messages.TOOLTIP_REDUCE_SEVERITY);
        new Label(comp, 0);
        this._runNow = new Button(comp, 8);
        this._runNow.setText(Messages.LABEL_RUN_NOW);
        this._runNow.setToolTipText(Messages.TOOLTIP_RUN_NOW);
        this._runNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean response;
                if (ArtifactValidationPreferencePage.this._prefs.isDirty() && (response = MessageDialog.openQuestion((Shell)ArtifactValidationPreferencePage.this.getShell(), (String)Messages.SAVE_PREFS_TITLE, (String)Messages.SAVE_PREFS_DESCRIPTION))) {
                    ArtifactValidationPreferencePage.this._prefs.save();
                    return;
                }
                PageDefinitionMarkerManager.validateWorkspace();
            }
        });
        this.setupBinding();
        return comp;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        if (this._preferenceStore == null) {
            this._preferenceStore = new UIValidationPreferencesHelper().getPreferencesStore();
        }
        return this._preferenceStore;
    }

    private void setupBinding() {
        this._context = new DataBindingContext();
        ISWTObservableValue validationUITarget = WidgetProperties.selection().observe((Widget)this._disableValidation);
        IObservableValue validationModel = BeanProperties.value(ArtifactValidationPreferences.class, (String)"validationDisabled").observe((Object)this._prefs);
        this._context.bindValue((IObservableValue)validationUITarget, validationModel);
        ISWTObservableValue makeWarningsUiTarget = WidgetProperties.selection().observe((Widget)this._makeErrorsWarnings);
        IObservableValue makeWarningsModel = BeanProperties.value(ArtifactValidationPreferences.class, (String)"makeErrorsWarnings").observe((Object)this._prefs);
        this._context.bindValue((IObservableValue)makeWarningsUiTarget, makeWarningsModel);
        ISWTObservableValue makeWarningsUiDisablementTarget = WidgetProperties.enabled().observe((Widget)this._makeErrorsWarnings);
        this._context.bindValue((IObservableValue)makeWarningsUiDisablementTarget, validationModel, new UpdateValueStrategy(), new UpdateValueStrategy().setConverter((IConverter)new Converter(Boolean.class, Boolean.class){

            public Object convert(Object fromObject) {
                return (Boolean)fromObject == false;
            }
        }));
        ISWTObservableValue runNowUITarget = WidgetProperties.visible().observe((Widget)this._runNow);
        this._context.bindValue((IObservableValue)runNowUITarget, (IObservableValue)makeWarningsUiDisablementTarget);
    }

    public void init(IWorkbench workbench) {
    }

    public String getDescription() {
        return Messages.PREF_PAGE_DESCRIPTION;
    }

    public void dispose() {
        super.dispose();
        if (this._context != null) {
            this._context.dispose();
        }
    }

    protected void performApply() {
        this._prefs.save();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performDefaults() {
        this._prefs.resetToDefaults();
    }

    private static class Messages
    extends NLS {
        private static final String BUNDLE_NAME = ArtifactValidationPreferencePage.class.getName();
        public static String LABEL_DISABLE_VALIDATION;
        public static String LABEL_REDUCE_SEVERITY;
        public static String TOOLTIP_REDUCE_SEVERITY;
        public static String LABEL_RUN_NOW;
        public static String TOOLTIP_RUN_NOW;
        public static String PREF_PAGE_DESCRIPTION;
        public static String SAVE_PREFS_TITLE;
        public static String SAVE_PREFS_DESCRIPTION;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, Messages.class);
        }

        private Messages() {
        }
    }
}

