/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.editor.CommonEditor;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDisposable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.progress.UIJob;

final class SelectionHandler
implements IDisposable {
    private CommonEditor<?> editor;
    private SelectionHelper editorSelectionHelper;
    private Map<String, SelectionHelper> outlineSelectionHelpers;
    private URI lastSelectedObjectURI;

    public void dispose() {
        if (this.editorSelectionHelper != null) {
            this.editorSelectionHelper.dispose();
            this.editorSelectionHelper = null;
        }
        if (this.outlineSelectionHelpers != null) {
            DTRTUtil.dispose(this.outlineSelectionHelpers.values());
            this.outlineSelectionHelpers.clear();
            this.outlineSelectionHelpers = null;
        }
    }

    public SelectionHandler(CommonEditor<?> editor) {
        this.editor = editor;
        this.editorSelectionHelper = new SelectionHelper(editor);
        this.editorSelectionHelper.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                URI uri;
                ISelection selection = DTRTUIUtil.toNotNullSelection(event);
                Object element = DTRTUIUtil.getFirstElement(selection);
                if (element instanceof IObject && (uri = ((IObject)element).getURI()) != null) {
                    SelectionHandler.this.lastSelectedObjectURI = uri;
                }
                SelectionHandler.this.setEditorSelection(DTRTUIUtil.toNotNullSelection(event), true);
            }
        });
    }

    public URI getLastSelectedObjectURI() {
        return this.lastSelectedObjectURI;
    }

    public void createSelectionHelper(Outline<?> outline) {
        if (this.outlineSelectionHelpers == null) {
            this.outlineSelectionHelpers = new HashMap<String, SelectionHelper>();
        }
        SelectionHelper selectionHelper = new SelectionHelper();
        if (this.outlineSelectionHelpers.put(outline.getId(), selectionHelper) != null) {
            throw new IllegalStateException("There is already a selection helper for the outline " + outline.getId());
        }
        selectionHelper.addSelectionChangedListener(this.editorSelectionHelper);
        selectionHelper.addSelectionChangedListener(outline);
    }

    public SelectionHelper getSelectionHelper(CommonEditor<?> commonEditor) {
        return this.editorSelectionHelper;
    }

    public SelectionHelper getSelectionHelper(EditorPage<?> editorPage) {
        return editorPage != null ? this.getSelectionHelper(editorPage.getOutline()) : null;
    }

    public SelectionHelper getSelectionHelper(Outline<?> outline) {
        return this.outlineSelectionHelpers != null && outline != null ? this.outlineSelectionHelpers.get(outline.getId()) : null;
    }

    private void setEditorSelection(final ISelection selection, boolean clearFilter) {
        for (final EditorPage<?> editorPage : this.editor.getEditorPages()) {
            if (!editorPage.canHandleEditorSelection(selection) || this.getSelectionHelper(editorPage) == null) continue;
            if (clearFilter && !selection.equals(editorPage.getSelection()) && editorPage.clearFilter()) {
                UIJob job = new UIJob(this.editor.getSite().getShell().getDisplay(), "Select in DataControl Page"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SelectionHandler.this.setEditorSelection(editorPage, selection);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule(200L);
                break;
            }
            this.setEditorSelection(editorPage, selection);
            break;
        }
    }

    private void setEditorSelection(EditorPage<?> editorPage, ISelection selection) {
        SelectionHelper selectionHelper = this.getSelectionHelper(editorPage);
        if (editorPage.getManagedForm() == null) {
            selectionHelper.setSelection(selection);
        } else {
            selectionHelper.setSelectionAndNotify(selection);
        }
        this.editor.setActivePage(editorPage.getId());
    }
}

