/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public abstract class OutlineView<T extends IOEPEExecutableContext>
extends Page {
    private Outline<T> outline = this.createOutline();

    public OutlineView(EditorPage<T> editorPage, FormToolkit toolkit) {
        this.outline.setToolkit(toolkit);
    }

    protected abstract Outline<T> createOutline();

    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().setSelectionProvider(null);
        }
        if (this.outline != null) {
            this.outline.dispose();
            this.outline = null;
        }
        super.dispose();
    }

    public final boolean isDisposed() {
        return this.outline == null;
    }

    public final Outline<T> getOutline() {
        return this.outline;
    }

    final SelectionHelper getSelectionHelper() {
        return this.outline.getEditorPage().getEditor().getSelectionHandler().getSelectionHelper(this.outline);
    }

    public final void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this.getSelectionHelper());
    }

    public final void createControl(Composite parent) {
        this.outline.createControl(parent);
        this.getOutline().getEditorPage().applyEditorHelpContext(this.getControl());
        ISelection selection = this.outline.getSelection();
        if (!selection.isEmpty()) {
            this.outline.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.outline.getSelectionHelper(), selection));
        }
    }

    public final Control getControl() {
        return this.outline != null ? this.outline.getControl() : null;
    }

    public final void setActionBars(IActionBars actionBars) {
        this.outline.fillToolBar(actionBars);
        IUndoContext undoContext = this.outline.getEditorPage().getEditor().getUndoContext();
        new UndoRedoActionGroup(this.outline.getEditorPage().getSite(), undoContext, true).fillActionBars(actionBars);
    }

    public final void setFocus() {
        this.outline.setFocus();
    }
}

