/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.editor;

import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.editor.EditorPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.ObjectDetailsPage;
import oracle.eclipse.tools.adf.dtrt.ui.editor.Outline;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.SaveSummaryCollectorDialog;
import oracle.eclipse.tools.adf.dtrt.ui.util.SelectionHelper;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.util.SaveSummaryCollector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class OutlineBlock<T extends IOEPEExecutableContext>
extends MasterDetailsBlock
implements IDetailsPageProvider {
    private static final String DS_OUTLINE_ACTION_CHECKED = "OutlineAction.checked";
    private static final String DS_SASH_WEIGHT0 = "Sash.weight0";
    private static final String DS_SASH_WEIGHT1 = "Sash.weight1";
    private static final int[] DEFAULT_WEIGTHS = new int[]{40, 60};
    private Outline<T> outline;
    private Listener resizeListener;
    private SelectionListenerSectionPart sectionPart;

    public OutlineBlock(EditorPage<T> editorPage) {
        this.outline = this.createOutline(editorPage);
    }

    protected abstract Outline<T> createOutline(EditorPage<T> var1);

    public void dispose() {
        if (this.outline != null) {
            if (this.resizeListener != null) {
                Control control = this.outline.getControl();
                if (control != null && !control.isDisposed()) {
                    control.removeListener(11, this.resizeListener);
                }
                this.resizeListener = null;
            }
            this.outline.dispose();
            this.outline = null;
        }
        if (this.sectionPart != null) {
            this.sectionPart.dispose();
            this.sectionPart = null;
        }
    }

    protected final void applyLayout(Composite parent) {
        super.applyLayout(parent);
        if (parent.getLayout() instanceof GridLayout) {
            GridLayout layout = (GridLayout)parent.getLayout();
            layout.marginTop = 15;
            layout.marginWidth = 5;
            layout.marginBottom = 10;
        }
    }

    protected EditorPage<T> getEditorPage() {
        return this.outline.getEditorPage();
    }

    final SelectionHelper getOutlineSelectionHelper() {
        return this.outline.getSelectionHelper();
    }

    protected final void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        this.outline.setToolkit(toolkit);
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.masterTitle);
        section.clientVerticalSpacing = 10;
        section.marginWidth = 5;
        this.getEditorPage().getEditor().validateObjects(null);
        this.sectionPart = new SelectionListenerSectionPart(section);
        managedForm.addPart((IFormPart)this.sectionPart);
        this.getOutlineSelectionHelper().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)OutlineBlock.this.sectionPart, event.getSelection());
            }
        });
        this.outline.createControl((Composite)section);
        section.setClient(this.outline.getControl());
        this.resizeListener = new Listener(){

            public void handleEvent(Event event) {
                if (OutlineBlock.this.outline != null && OutlineBlock.this.sashForm != null && !OutlineBlock.this.sashForm.isDisposed()) {
                    OutlineBlock.this.setPersistedSashWeights(OutlineBlock.this.sashForm.getWeights());
                }
            }
        };
        this.outline.getControl().addListener(11, this.resizeListener);
        ToolBar toolBar = new ToolBar((Composite)section, 256);
        this.outline.fillToolBar(toolBar);
        section.setTextClient((Control)toolBar);
    }

    public Outline<T> getOutline() {
        return this.outline;
    }

    protected final void createToolBarActions(IManagedForm managedForm) {
        this.sashForm.setWeights(this.getPersistedSashWeights());
        IToolBarManager toolBarManager = managedForm.getForm().getToolBarManager();
        this.updateToolBarActions(toolBarManager);
    }

    protected final void updateToolBarActions(IToolBarManager toolBarManager) {
        if (toolBarManager != null) {
            boolean toolBarHasContributions;
            boolean bl = toolBarHasContributions = !toolBarManager.isEmpty();
            if (toolBarHasContributions) {
                toolBarManager.removeAll();
            }
            this.doUpdateToolBarActions(toolBarManager);
            if (toolBarHasContributions) {
                toolBarManager.update(true);
            }
        }
    }

    protected void doUpdateToolBarActions(IToolBarManager toolBarManager) {
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        this.addShowModifiedFilesButton(toolBarManager);
        this.addHideOutlineButton(toolBarManager);
    }

    protected final void addShowModifiedFilesButton(IToolBarManager toolBarManager) {
        Action showModifiedFilesAction = new Action(){

            public void run() {
                SaveSummaryCollector saveSummaryCollector = OutlineBlock.this.getOutline().getEditorPage().getEditor().getSaveSummaryCollector();
                Shell shell = OutlineBlock.this.getOutline().getControl().getShell();
                if (saveSummaryCollector.isEmpty()) {
                    MessageDialog.openInformation((Shell)shell, (String)Messages.modifiedFilesTitle, (String)Messages.noModifiedFilesMessage);
                } else {
                    SaveSummaryCollectorDialog dialog = new SaveSummaryCollectorDialog(shell, saveSummaryCollector);
                    DTRTUIUtil.centerDialog(shell, (Dialog)dialog);
                    dialog.open();
                }
            }
        };
        showModifiedFilesAction.setToolTipText(Messages.modifiedFiles);
        showModifiedFilesAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_FILE_CHANGES)));
        toolBarManager.add((IAction)showModifiedFilesAction);
    }

    protected final void addHideOutlineButton(IToolBarManager toolBarManager) {
        Action hideOutlineAction = new Action(null, 2){
            private int[] weights;

            public void run() {
                IDialogSettings dialogSettings = OutlineBlock.this.getEditorPage().getDialogSettings();
                if (dialogSettings != null) {
                    dialogSettings.put(OutlineBlock.DS_OUTLINE_ACTION_CHECKED, this.isChecked());
                }
                if (this.isChecked()) {
                    this.weights = OutlineBlock.this.sashForm.getWeights();
                    int[] nArray = new int[2];
                    nArray[1] = 10;
                    OutlineBlock.this.sashForm.setWeights(nArray);
                } else {
                    if (this.weights == null) {
                        this.weights = OutlineBlock.this.getPersistedSashWeights();
                    }
                    OutlineBlock.this.sashForm.setWeights(this.weights);
                }
            }
        };
        hideOutlineAction.setToolTipText(Messages.hideOutline);
        hideOutlineAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_HIDE_OUTLINE)));
        toolBarManager.add((IAction)hideOutlineAction);
        IDialogSettings dialogSettings = this.getEditorPage().getDialogSettings();
        if (dialogSettings != null) {
            hideOutlineAction.setChecked(dialogSettings.getBoolean(DS_OUTLINE_ACTION_CHECKED));
        }
    }

    public IDetailsPage getPage(Object key) {
        return null;
    }

    private void setPersistedSashWeights(int[] weights) {
        String editorInputKey;
        EditorPage<T> editorPage = this.getEditorPage();
        IDialogSettings dialogSettings = editorPage.getDialogSettings();
        if (dialogSettings != null && weights[0] > 0 && (editorInputKey = editorPage.getEditor().getEditorInputKey()) != null) {
            String key0 = DS_SASH_WEIGHT0 + editorInputKey;
            String key1 = DS_SASH_WEIGHT1 + editorInputKey;
            dialogSettings.put(key0, weights[0]);
            dialogSettings.put(key1, weights[1]);
        }
    }

    private int[] getPersistedSashWeights() {
        int[] weights = null;
        EditorPage<T> editorPage = this.getEditorPage();
        IDialogSettings dialogSettings = editorPage.getDialogSettings();
        if (dialogSettings != null) {
            if (dialogSettings.getBoolean(DS_OUTLINE_ACTION_CHECKED)) {
                int[] nArray = new int[2];
                nArray[1] = 10;
                weights = nArray;
            } else {
                String editorInputKey = editorPage.getEditor().getEditorInputKey();
                if (editorInputKey != null) {
                    String key0 = DS_SASH_WEIGHT0 + editorInputKey;
                    String key1 = DS_SASH_WEIGHT1 + editorInputKey;
                    weights = this.getSashWeights(dialogSettings, key0, key1);
                }
            }
        }
        if (weights == null) {
            weights = DEFAULT_WEIGTHS;
        }
        return weights;
    }

    private int[] getSashWeights(IDialogSettings dialogSettings, String key0, String key1) {
        try {
            int[] weights = new int[]{dialogSettings.getInt(key0), dialogSettings.getInt(key1)};
            return weights;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public final ObjectDetailsPage<T> getObjectDetailsPage() {
        IDetailsPage detailsPage;
        if (this.detailsPart != null && (detailsPage = this.detailsPart.getCurrentPage()) instanceof ObjectDetailsPage) {
            return (ObjectDetailsPage)detailsPage;
        }
        return null;
    }

    private static class Messages
    extends NLS {
        public static String masterTitle;
        public static String modifiedFiles;
        public static String modifiedFilesTitle;
        public static String noModifiedFilesMessage;
        public static String hideOutline;

        static {
            NLS.initializeMessages((String)OutlineBlock.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private class SelectionListenerSectionPart
    extends SectionPart
    implements IPartSelectionListener {
        public SelectionListenerSectionPart(Section section) {
            super(section);
        }

        public void selectionChanged(IFormPart part, ISelection selection) {
            OutlineBlock.this.getOutlineSelectionHelper().setSelectionAndNotify(selection);
            OutlineBlock.this.outline.setFocus();
        }
    }
}

