/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.context.manager;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEContext;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.util.UIExceptionHandler;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.DataControlProviderAdapter;
import oracle.eclipse.tools.adf.dtrt.util.ExecutableContextAdapter;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ContextManager<C extends IOEPEContext> {
    private Map<IWorkbenchPart, C> contextByPart = new IdentityHashMap<IWorkbenchPart, C>();
    private StructureChangeHandler structureChangeHandler = new StructureChangeHandler();
    private Set<IWorkbenchPart> partWithStructureChanges = new HashSet<IWorkbenchPart>();
    private ExternalChangeHandler externalChangeHandler = new ExternalChangeHandler();
    private Set<IWorkbenchPart> partWithExternalChanges = new HashSet<IWorkbenchPart>();

    protected ContextManager() {
    }

    public synchronized void dispose() {
        if (this.partWithStructureChanges != null) {
            this.partWithStructureChanges.clear();
            this.partWithStructureChanges = null;
        }
        if (this.partWithExternalChanges != null) {
            this.partWithExternalChanges.clear();
            this.partWithExternalChanges = null;
        }
        if (this.contextByPart != null) {
            for (Map.Entry<IWorkbenchPart, C> entry : this.contextByPart.entrySet()) {
                try {
                    this.contextUnset(entry.getKey(), (IOEPEContext)entry.getValue());
                }
                catch (Exception exception) {}
                ((IOEPEContext)entry.getValue()).dispose();
            }
            this.contextByPart.clear();
            this.contextByPart = null;
        }
    }

    public final C getContext(IWorkbenchPart part) {
        return (C)((IOEPEContext)this.contextByPart.get(part));
    }

    protected final void setContext(IWorkbenchPart part, C context) {
        this.contextByPart.put(part, context);
    }

    protected final void partActivated(IWorkbenchPart part) {
        if (!this.contextByPart.containsKey(part)) {
            this.partOpened(part);
        } else if (this.partWithStructureChanges.contains(part)) {
            this.handleStructureChange(part);
        } else if (this.partWithExternalChanges.contains(part)) {
            this.handleExternalChange(part);
        }
    }

    protected final StructureChangeHandler getStructureChangeHandler() {
        return this.structureChangeHandler;
    }

    protected final ExternalChangeHandler getExternalChangeHandler() {
        return this.externalChangeHandler;
    }

    protected abstract void partOpened(IWorkbenchPart var1);

    protected final void partClosed(IWorkbenchPart part) {
        this.partWithStructureChanges.remove(part);
        this.partWithExternalChanges.remove(part);
        IOEPEContext context = (IOEPEContext)this.contextByPart.remove(part);
        if (context != null) {
            this.contextUnset(part, context);
            context.dispose();
        }
    }

    protected void contextUnset(IWorkbenchPart part, C context) {
    }

    protected final void editorSaved(IWorkbenchPart part) {
        Object context = null;
        if (part != null) {
            context = this.getContext(part);
            assert (context != null);
            if (context instanceof IOEPEExecutableContext) {
                try {
                    ((IOEPEExecutableContext)context).save(null);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e2) {
                    CoreException e2 = new CoreException(DTRTUtil.createErrorStatus((String)Messages.errorSavingBindings, (Throwable)e2));
                    UIExceptionHandler.DEFAULT.handleException((Exception)e2);
                }
            }
        }
    }

    protected final void editorReverted(IWorkbenchPart part) {
        if (part != null) {
            C context = this.getContext(part);
            assert (context != null);
            try {
                context.reset(null);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                e = new CoreException(DTRTUtil.createErrorStatus((String)Messages.errorSavingBindings, (Throwable)e));
                UIExceptionHandler.DEFAULT.handleException((Exception)((Object)e));
            }
        }
    }

    private void handleStructureChange(IWorkbenchPart part) {
        assert (this.partWithStructureChanges.contains(part));
        this.partWithStructureChanges.remove(part);
        C context = this.getContext(part);
        if (context instanceof IOEPEExecutableContext && ((IOEPEExecutableContext)context).isDirty()) {
            MessageDialog.openInformation((Shell)DTRTUIUtil.getShell(part), (String)Messages.structureChangeTitle, (String)Messages.structureChangeInfo);
        } else {
            try {
                ((IDataControlProvider)context).resetStructures(null);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                UIExceptionHandler.DEFAULT.handleException((Exception)((Object)e));
            }
        }
    }

    private void handleExternalChange(IWorkbenchPart part) {
        assert (this.partWithExternalChanges.contains(part));
        this.partWithExternalChanges.remove(part);
        C context = this.getContext(part);
        assert (context != null);
        if (context instanceof IOEPEExecutableContext && ((IOEPEExecutableContext)context).isDirty()) {
            MessageDialog.openInformation((Shell)DTRTUIUtil.getShell(part), (String)Messages.externalChangeTitle, (String)Messages.externalChangeInfo);
        } else {
            try {
                context.reset(null);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CoreException e) {
                UIExceptionHandler.DEFAULT.handleException((Exception)((Object)e));
            }
        }
    }

    private class ExternalChangeHandler
    extends ExecutableContextAdapter {
        private ExternalChangeHandler() {
        }

        public void handleExternalChange(IOEPEContext context) {
            if (ContextManager.this.contextByPart != null) {
                for (Map.Entry entry : ContextManager.this.contextByPart.entrySet()) {
                    if (entry.getValue() != context) continue;
                    IWorkbenchPart part = (IWorkbenchPart)entry.getKey();
                    if (ContextManager.this.partWithStructureChanges.contains(part)) continue;
                    ContextManager.this.partWithExternalChanges.add(part);
                    if (part.getSite().getWorkbenchWindow().getActivePage().getActivePart() != part) break;
                    ContextManager.this.handleExternalChange(part);
                    break;
                }
            }
        }
    }

    private static class Messages
    extends NLS {
        public static String errorSavingBindings;
        public static String structureChangeTitle;
        public static String structureChangeInfo;
        public static String externalChangeTitle;
        public static String externalChangeInfo;

        static {
            NLS.initializeMessages((String)ContextManager.class.getName(), Messages.class);
        }

        private Messages() {
        }
    }

    private class StructureChangeHandler
    extends DataControlProviderAdapter {
        private StructureChangeHandler() {
        }

        public void handleStructureChange(IDataControlProvider provider) {
            if (provider instanceof IOEPEContext && ContextManager.this.contextByPart != null) {
                for (Map.Entry entry : ContextManager.this.contextByPart.entrySet()) {
                    if (entry.getValue() != provider) continue;
                    IWorkbenchPart part = (IWorkbenchPart)entry.getKey();
                    ContextManager.this.partWithStructureChanges.add(part);
                    ContextManager.this.partWithExternalChanges.remove(part);
                    if (part.getSite().getWorkbenchWindow().getActivePage().getActivePart() != part) break;
                    ContextManager.this.handleStructureChange(part);
                    break;
                }
            }
        }
    }
}

