/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.ui.context;

import java.util.concurrent.atomic.AtomicBoolean;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.ui.context.IUIObjectEditor;
import oracle.eclipse.tools.adf.dtrt.ui.internal.DTRTUIBundle;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.ui.viewer.DescribableViewer;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.TypedListenerList;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BasicObjectEditor
implements IUIObjectEditor,
DisposeListener {
    private IObject object;
    private Control control;
    protected DescribableViewer objectViewer;
    protected Text typeText;
    private AtomicBoolean isDisposed = new AtomicBoolean();
    private TypedListenerList<ISelectionListener> objectSelectionListeners;
    private IUIObjectEditor.IObjectEditorClient client;

    public BasicObjectEditor(IObject object) {
        assert (object != null);
        this.object = object;
        this.objectSelectionListeners = new TypedListenerList();
    }

    public void dispose() {
        if (this.isDisposed.compareAndSet(false, true)) {
            this.client = null;
            if (this.control != null) {
                this.control.removeDisposeListener((DisposeListener)this);
                this.control = null;
            }
            if (this.objectSelectionListeners != null) {
                this.objectSelectionListeners.clear();
                this.objectSelectionListeners = null;
            }
            this.object = null;
            this.objectViewer = null;
            this.typeText = null;
        }
    }

    @Override
    public void setClient(IUIObjectEditor.IObjectEditorClient client) {
        this.client = client;
    }

    @Override
    public IUIObjectEditor.IObjectEditorClient getClient() {
        return this.client;
    }

    public final void widgetDisposed(DisposeEvent e) {
        this.dispose();
        assert (this.isDisposed.get()) : "You must call super from you object editor dispose";
    }

    public IObject getObject() {
        return this.object;
    }

    @Override
    public final void addObjectSelectionListener(ISelectionListener listener) {
        this.objectSelectionListeners.add((Object)listener);
    }

    @Override
    public final void removeObjectSelectionListener(ISelectionListener listener) {
        this.objectSelectionListeners.remove((Object)listener);
    }

    protected final void notifyObjectSelectionListeners(ISelection selection) {
        IWorkbenchPart part;
        try {
            part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        }
        catch (Exception exception) {
            part = null;
        }
        for (ISelectionListener listener : this.objectSelectionListeners) {
            try {
                listener.selectionChanged(part, selection);
            }
            catch (Exception e) {
                DTRTUIBundle.log(e);
            }
        }
    }

    @Override
    public final Control createControl(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        if (this.control == null) {
            Control control = this.doCreateControl(managedForm, toolkit, parent);
            assert (control != null);
            control.addDisposeListener((DisposeListener)this);
            this.control = control;
        }
        return this.control;
    }

    protected Control doCreateControl(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        Composite composite = toolkit.createComposite(parent, 64);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        toolkit.paintBordersFor(composite);
        this.addControls(managedForm, toolkit, composite);
        return composite;
    }

    protected void addControls(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.createObjectViewer(toolkit, parent);
        this.createTypeText(toolkit, parent);
    }

    protected void createObjectViewer(FormToolkit toolkit, Composite parent) {
        DTRTUIUtil.createSectionLabel(toolkit, parent, BasicObjectEditorMessages.objectLabel);
        this.objectViewer = new DescribableViewer();
        DTRTUIUtil.applyGrabHorizontallyGridData(this.objectViewer.createControl(toolkit, parent, false, false));
    }

    protected void createTypeText(FormToolkit toolkit, Composite parent) {
        this.typeText = DTRTUIUtil.createTextRow(toolkit, parent, BasicObjectEditorMessages.typeLabel, 8);
    }

    @Override
    public boolean isStale() {
        return this.getClient() != null && this.getClient().isObjectEditorStale();
    }

    @Override
    public final void setFocus() {
        if (this.control != null) {
            this.control.setFocus();
        }
    }

    @Override
    public void refresh() {
        if (this.objectViewer != null) {
            this.objectViewer.setInput((IDescribable)this.getObject());
        }
        if (this.typeText != null) {
            this.typeText.setText(DTRTUtil.toNotNullString((String)this.getType()));
        }
    }

    protected String getType() {
        IDescriptor typeDescriptor = this.getObject().getTypeDescriptor();
        return DTRTUtil.getLabel((IDescriptor)typeDescriptor);
    }

    public final boolean isDisposed() {
        return this.isDisposed.get();
    }

    @Override
    public void handleGlobalActionExecution(String actionId, Control control, Event event) {
    }

    protected static class BasicObjectEditorMessages
    extends NLS {
        public static String objectLabel;
        public static String typeLabel;

        static {
            NLS.initializeMessages((String)BasicObjectEditor.class.getName(), BasicObjectEditorMessages.class);
        }

        protected BasicObjectEditorMessages() {
        }
    }
}

