/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public final class UpgradeNoticePanel
extends Composite {
    private final Label noticeLabel;
    private final List projects;

    public UpgradeNoticePanel(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.noticeLabel = new Label((Composite)this, 64);
        this.noticeLabel.setLayoutData((Object)SwtUtil.gdwhint((GridData)SwtUtil.gdhfill(), (int)350));
        this.noticeLabel.setText(Resources.upgradeNoticeMessage);
        Color bgcolor = Display.getCurrent().getSystemColor(22);
        this.projects = new List((Composite)this, 2560);
        this.projects.setLayoutData((Object)SwtUtil.gdvindent((GridData)SwtUtil.gdfill(), (int)5));
        this.projects.setBackground(bgcolor);
    }

    public void setProjects(Set<IProject> projects) {
        this.projects.removeAll();
        ArrayList<IProject> sortedList = new ArrayList<IProject>(projects);
        Comparator<IProject> comparator = new Comparator<IProject>(){

            @Override
            public int compare(IProject pj1, IProject pj2) {
                return pj1.getName().compareToIgnoreCase(pj2.getName());
            }
        };
        Collections.sort(sortedList, comparator);
        for (IProject proj : sortedList) {
            this.projects.add(proj.getName());
        }
    }

    private static final class Resources
    extends NLS {
        public static String upgradeNoticeMessage;

        static {
            Resources.initializeMessages((String)UpgradeNoticePanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

