/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeLog;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.common.util.MiscUtil;
import oracle.eclipse.tools.common.util.XmlParseException;
import oracle.eclipse.tools.common.util.fileio.EclipseFileUtil;
import oracle.eclipse.tools.common.util.fileio.XmlWriter;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;

public final class ProjectUpgradeLog
implements IProjectUpgradeLog {
    private static final String FILE_NAME = ".settings/oracle.eclipse.tools.common.upgrade.log.xml";
    private static final String EL_ENTRY = "entry";
    private static final String EL_UPGRADE_LOG = "upgrade-log";
    private static final String EL_UPGRADE_PARTICIPANT = "upgrade-participant";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PLUGIN_ID = "pluginId";
    private static final String ATTR_PLUGIN_VERSION = "pluginVersion";
    private static final String ATTR_TIME = "time";
    private final IProject project;
    private final IFile logFile;
    private long logFileModificationStamp;
    private final List<IProjectUpgradeLog.ILogEntry> entries;

    public ProjectUpgradeLog(IProject project) {
        this.project = (IProject)MiscUtil.checkNotNull((Object)project);
        this.logFile = this.project.getFile(FILE_NAME);
        this.logFileModificationStamp = -1L;
        this.entries = new CopyOnWriteArrayList<IProjectUpgradeLog.ILogEntry>();
        this.refresh();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    public IFile getLogFile() {
        return this.logFile;
    }

    @Override
    public List<IProjectUpgradeLog.ILogEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProjectUpgradeLog.ILogEntry findLastLogEntry(String className) {
        ProjectUpgradeLog projectUpgradeLog = this;
        synchronized (projectUpgradeLog) {
            int i = this.entries.size() - 1;
            while (i >= 0) {
                IProjectUpgradeLog.ILogEntry entry = this.entries.get(i);
                if (entry.getParticipantRecord().getClassName().equals(className)) {
                    return entry;
                }
                --i;
            }
            return null;
        }
    }

    public void addEntry(String pluginId, String pluginVersion, String className) {
        LogEntry entry = new LogEntry(new ParticipantRecord(pluginId, pluginVersion, className));
        this.entries.add(entry);
        this.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        ProjectUpgradeLog projectUpgradeLog = this;
        synchronized (projectUpgradeLog) {
            long newModificationStamp = this.logFile.getModificationStamp();
            if (this.logFileModificationStamp == newModificationStamp) {
                return;
            }
            ArrayList<LogEntry> newLogEntries = new ArrayList<LogEntry>();
            if (this.logFile.isAccessible()) {
                try {
                    InputStream in = this.logFile.getContents();
                    try {
                        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                        for (Element elEntry : DomUtil.elements((Element)DomUtil.root((Reader)reader), (String)EL_ENTRY)) {
                            LogEntry entry = LogEntry.read(elEntry);
                            if (entry == null) continue;
                            newLogEntries.add(entry);
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (CoreException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (CoreException)e);
                }
                catch (XmlParseException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (Throwable)e);
                }
            }
            this.entries.clear();
            this.entries.addAll(newLogEntries);
            this.logFileModificationStamp = newModificationStamp;
        }
    }

    private void write() {
        StringWriter sw = new StringWriter();
        try {
            XmlWriter xmlw = new XmlWriter((Writer)sw);
            xmlw.startElement(EL_UPGRADE_LOG);
            for (IProjectUpgradeLog.ILogEntry entry : this.entries) {
                ((LogEntry)entry).write(xmlw);
            }
            xmlw.endElement();
        }
        catch (IOException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (Throwable)e);
        }
        try {
            EclipseFileUtil.writeFile((IFile)this.logFile, (String)sw.toString());
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.upgrade", (CoreException)e);
        }
    }

    private static final class LogEntry
    implements IProjectUpgradeLog.ILogEntry {
        private static final DateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        private final Date time;
        private final ParticipantRecord participantRecord;

        static {
            TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public LogEntry(ParticipantRecord participantRecord) {
            this(new Date(), participantRecord);
        }

        public LogEntry(Date time, ParticipantRecord participantRecord) {
            this.time = (Date)MiscUtil.checkNotNull((Object)time);
            this.participantRecord = (ParticipantRecord)MiscUtil.checkNotNull((Object)participantRecord);
        }

        @Override
        public Date getTime() {
            return this.time;
        }

        @Override
        public IProjectUpgradeLog.IParticipantRecord getParticipantRecord() {
            return this.participantRecord;
        }

        public void write(XmlWriter out) throws IOException {
            out.startElement(ProjectUpgradeLog.EL_ENTRY);
            out.addAttribute(ProjectUpgradeLog.ATTR_TIME, LogEntry.convert(this.time));
            this.participantRecord.write(out);
            out.endElement();
        }

        public static LogEntry read(Element element) {
            ParticipantRecord precord;
            Date time = LogEntry.convert(element.getAttribute(ProjectUpgradeLog.ATTR_TIME).trim());
            Element elParticipantRecord = DomUtil.element((Element)element, (String)ProjectUpgradeLog.EL_UPGRADE_PARTICIPANT);
            if (time != null && elParticipantRecord != null && (precord = ParticipantRecord.read(elParticipantRecord)) != null) {
                return new LogEntry(time, precord);
            }
            return null;
        }

        private static String convert(Date time) {
            return TIME_FORMAT.format(time);
        }

        private static Date convert(String time) {
            try {
                return TIME_FORMAT.parse(time);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    private static final class ParticipantRecord
    implements IProjectUpgradeLog.IParticipantRecord {
        private final String pluginId;
        private final String pluginVersion;
        private final String className;

        public ParticipantRecord(String pluginId, String pluginVersion, String className) {
            this.pluginId = (String)MiscUtil.checkNotNull((Object)pluginId);
            this.pluginVersion = (String)MiscUtil.checkNotNull((Object)pluginVersion);
            this.className = (String)MiscUtil.checkNotNull((Object)className);
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getPluginId() {
            return this.pluginId;
        }

        @Override
        public String getPluginVersion() {
            return this.pluginVersion;
        }

        public void write(XmlWriter out) throws IOException {
            out.startElement(ProjectUpgradeLog.EL_UPGRADE_PARTICIPANT);
            out.addAttribute(ProjectUpgradeLog.ATTR_PLUGIN_ID, this.pluginId);
            out.addAttribute(ProjectUpgradeLog.ATTR_PLUGIN_VERSION, this.pluginVersion);
            out.addAttribute(ProjectUpgradeLog.ATTR_CLASS, this.className);
            out.endElement();
        }

        public static ParticipantRecord read(Element element) {
            String pluginId = element.getAttribute(ProjectUpgradeLog.ATTR_PLUGIN_ID).trim();
            String pluginVersion = element.getAttribute(ProjectUpgradeLog.ATTR_PLUGIN_VERSION).trim();
            String className = element.getAttribute(ProjectUpgradeLog.ATTR_CLASS).trim();
            if (pluginId.length() == 0 || pluginVersion.length() == 0 || className.length() == 0) {
                return null;
            }
            return new ParticipantRecord(pluginId, pluginVersion, className);
        }
    }
}

