/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IProjectUpgradeParticipant {
    public boolean check(IProject var1) throws CoreException;

    public Set<Action> prepare(IProject var1) throws CoreException;

    public void execute(IProject var1, IProgressMonitor var2) throws CoreException;

    public static class Action {
        private final Type type;
        private final IFile file;

        public Action(Type type) {
            if (type == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.file = null;
        }

        public Action(Type type, IFile file) {
            if (type == null || file == null) {
                throw new NullPointerException();
            }
            this.type = type;
            this.file = file;
        }

        public Type getType() {
            return this.type;
        }

        public IFile getFile() {
            return this.file;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Action)) {
                return false;
            }
            Action action = (Action)obj;
            return this.type == action.type && this.file.equals((Object)action.file);
        }

        public int hashCode() {
            if (this.file == null) {
                return this.type.hashCode();
            }
            return this.type.hashCode() ^ this.file.hashCode();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.type.name());
            buf.append(" [");
            buf.append(this.file.getLocation().toOSString());
            buf.append(']');
            return buf.toString();
        }

        public static enum Type {
            CREATE,
            DELETE,
            EDIT,
            CHANGE_MARKERS;

        }
    }
}

