/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.upgrade;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class AbstractClasspathUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    @Override
    public final boolean check(IProject project) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject jproject = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = jproject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (this.check(jproject, cpe)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        IFile f = project.getFile(".classpath");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    @Override
    public final void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        block9: {
            monitor.beginTask("", 10);
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) break block9;
                IJavaProject jproject = JavaCore.create((IProject)project);
                IClasspathEntry[] oldcp = jproject.getRawClasspath();
                ArrayList<Integer> entries = new ArrayList<Integer>();
                int i = 0;
                while (i < oldcp.length) {
                    if (this.check(jproject, oldcp[i])) {
                        entries.add(i);
                    }
                    ++i;
                }
                IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length];
                System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
                monitor.worked(2);
                SubProgressMonitor submon = new SubProgressMonitor(monitor, 6);
                submon.beginTask("", entries.size());
                try {
                    Iterator iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        int position = (Integer)iterator.next();
                        this.execute(jproject, newcp, position);
                        submon.worked(1);
                    }
                }
                finally {
                    submon.done();
                }
                jproject.setRawClasspath(newcp, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            finally {
                monitor.done();
            }
        }
    }

    protected abstract boolean check(IJavaProject var1, IClasspathEntry var2) throws CoreException;

    protected abstract void execute(IJavaProject var1, IClasspathEntry[] var2, int var3) throws CoreException;
}

