/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.model.Activator;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContextFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class NamespaceContextManager {
    private static List<INamespaceContextFactory> _handlers = null;

    public static INamespaceContext getNamespaceContext(IFile file) {
        for (INamespaceContextFactory factory : NamespaceContextManager.getAllHandlers()) {
            INamespaceContext namespaceContext = factory.getNamespaceContext(file);
            if (namespaceContext == null) continue;
            return namespaceContext;
        }
        return null;
    }

    public static INamespaceContext getNamespaceContext(IDOMModel domModel) {
        IFile file = NamespaceContextManager.getFile(domModel);
        if (file != null) {
            return NamespaceContextManager.getNamespaceContext(file);
        }
        return null;
    }

    private static IFile getFile(IDOMModel model) {
        IStructuredDocument doc = model.getStructuredDocument();
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)doc, -1);
        IWorkspaceContextResolver wkResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
        return (IFile)wkResolver.getResource();
    }

    private static synchronized List<INamespaceContextFactory> getAllHandlers() {
        if (_handlers == null) {
            _handlers = NamespaceContextManager.readAllHandlers();
        }
        return Collections.unmodifiableList(_handlers);
    }

    private static List<INamespaceContextFactory> readAllHandlers() {
        ArrayList<INamespaceContextFactory> result = new ArrayList<INamespaceContextFactory>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("oracle.eclipse.tools.xml.model", "namespaceContext");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] elementEditElement = ext.getConfigurationElements();
            int j = 0;
            while (j < elementEditElement.length) {
                IConfigurationElement element = elementEditElement[j];
                if (element.getName().equals("namespaceContext")) {
                    elementEditElement[j].getAttribute("factory");
                    try {
                        Object obj = elementEditElement[j].createExecutableExtension("factory");
                        if (obj instanceof INamespaceContextFactory) {
                            if (element.getContributor().getName().startsWith("org.eclipse.jst")) {
                                result.add((INamespaceContextFactory)obj);
                            } else {
                                result.add(0, (INamespaceContextFactory)obj);
                            }
                        }
                    }
                    catch (CoreException e) {
                        Activator.log("Problem loading element edit extension for " + element.toString(), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }
}

