/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.util;

public class MetaDataUtil {
    public static final String HOST_IDE_ATTR = "host-ide";
    public static final String HOST_IDE_MAJOR_VERSION_ATTR = "host-ide-major-version";
    public static final String BUNDLE = "bundle";
    public static final String KEY = "key";

    public static boolean checkVersion(String versionPattern, String versionNumber) {
        String versionStr;
        String operator;
        if (versionNumber == null) {
            throw new IllegalArgumentException("Invalid version: null");
        }
        int firstDot = versionNumber.indexOf(46);
        if (versionNumber.indexOf(46, firstDot + 1) != -1) {
            throw new IllegalArgumentException("version must be of form (0-9)+[.(0-9)+] : " + versionNumber + " is invalid");
        }
        double version = Double.parseDouble(versionNumber);
        if (versionPattern == null) {
            return true;
        }
        int versionIndex = 0;
        int i = 0;
        int n = versionPattern.length();
        while (i < n) {
            if (Character.isDigit(versionPattern.charAt(i))) {
                versionIndex = i;
                break;
            }
            ++i;
        }
        if (versionIndex == 0) {
            operator = "=";
            versionStr = versionPattern;
        } else {
            operator = versionPattern.substring(0, versionIndex).trim();
            versionStr = versionPattern.substring(versionIndex);
        }
        double testVersion = Double.parseDouble(versionStr);
        if (operator.equals("=")) {
            return version == testVersion;
        }
        if (operator.equals("<")) {
            return version < testVersion;
        }
        if (operator.equals("<=")) {
            return version <= testVersion;
        }
        if (operator.equals(">")) {
            return version > testVersion;
        }
        if (operator.equals(">=")) {
            return version >= testVersion;
        }
        assert (false);
        return false;
    }
}

