/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.tagdoc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.xml.model.Activator;
import oracle.eclipse.tools.xml.model.tagdoc.TagContextHelp;
import oracle.eclipse.tools.xml.model.tagdoc.TagDoc;
import oracle.eclipse.tools.xml.model.tagdoc.TagDocProvider;
import oracle.eclipse.tools.xml.model.tagdoc.TagInfo;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.help.IContext;

public final class TagDocSystem {
    private static final String EXTENSION_POINT_ID = "tagDocProviders";
    private static final String EL_PROVIDER = "provider";
    private static final String ATTR_CLASS = "class";
    private static List<TagDocProvider> contextHelpProviders;

    public static IContext getTagContextHelp(String namespace, String name, String version) {
        return TagDocSystem.getTagContextHelp(new TagInfo(namespace, name, version));
    }

    public static IContext getTagContextHelp(TagInfo taginfo) {
        TagDoc tagdoc = TagDocSystem.getTagDoc(taginfo);
        if (tagdoc != null) {
            return new TagContextHelp(tagdoc);
        }
        return null;
    }

    public static TagDoc getTagDoc(String namespace, String name, String version) {
        return TagDocSystem.getTagDoc(new TagInfo(namespace, name, version));
    }

    public static TagDoc getTagDoc(TagInfo taginfo) {
        TagDocSystem.initialize();
        for (TagDocProvider provider : contextHelpProviders) {
            try {
                TagDoc tagdoc = provider.getTagDoc(taginfo);
                if (tagdoc == null) continue;
                return tagdoc;
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
        return null;
    }

    private static synchronized void initialize() {
        if (contextHelpProviders == null) {
            contextHelpProviders = new ArrayList<TagDocProvider>();
            for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"oracle.eclipse.tools.xml.model", (String)EXTENSION_POINT_ID))) {
                String pluginId = element.getContributor().getName();
                if (!element.getName().equals(EL_PROVIDER)) continue;
                try {
                    String clname = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                    TagDocProvider provider = (TagDocProvider)PluginUtil.instantiate((String)pluginId, (String)clname, TagDocProvider.class);
                    if (provider == null) continue;
                    contextHelpProviders.add(provider);
                }
                catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
            }
        }
    }
}

