/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.tagdoc;

import oracle.eclipse.tools.xml.model.tagdoc.BundleResourceRef;
import oracle.eclipse.tools.xml.model.tagdoc.TagDoc;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelpResource;
import org.eclipse.osgi.util.NLS;

public final class TagContextHelp
implements IContext2 {
    private final TagDoc tagdoc;

    public TagContextHelp(TagDoc tagdoc) {
        this.tagdoc = tagdoc;
    }

    public String getTitle() {
        return this.tagdoc.getName();
    }

    public String getText() {
        return this.tagdoc.getDescription();
    }

    public String getStyledText() {
        return this.getText();
    }

    public IHelpResource[] getRelatedTopics() {
        IHelpResource topic = new IHelpResource(){

            public String getLabel() {
                return NLS.bind((String)Resources.relatedTopicLink, (Object)TagContextHelp.this.tagdoc.getName());
            }

            public String getHref() {
                BundleResourceRef ref = TagContextHelp.this.tagdoc.getHref();
                StringBuilder buf = new StringBuilder();
                buf.append('/');
                buf.append(ref.getBundleId());
                if (ref.getContextRoot() != null) {
                    buf.append('/');
                    buf.append(ref.getContextRoot());
                }
                buf.append('/');
                buf.append(ref.getPath());
                return buf.toString();
            }
        };
        return new IHelpResource[]{topic};
    }

    public String getCategory(IHelpResource topic) {
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String relatedTopicLink;

        static {
            Resources.initializeMessages((String)TagContextHelp.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

