/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.common.services.dom.AbstractServiceAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.BoundEObject;
import oracle.eclipse.tools.xml.model.service.ISemanticModelServiceAdapter;
import oracle.eclipse.tools.xml.model.service.ISemanticObjectFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Node;

class SemanticModelServiceAdapter
extends AbstractServiceAdapter
implements ISemanticModelServiceAdapter {
    private final Object _lock = new Object();
    private ISemanticObjectFactory<Node> _objectFactory;
    private final DOMModelHolder _domModelHolder;
    private final Resource _emfResource;
    private final Map<Node, BoundEObject> _model = new HashMap<Node, BoundEObject>();

    public SemanticModelServiceAdapter(DOMModelHolder modelHolder, ISemanticObjectFactory<Node> factory) {
        this._emfResource = factory.createResource(ISemanticObjectFactory.NO_RESOURCESET);
        this._domModelHolder = modelHolder;
        this._objectFactory = factory;
    }

    void setSemanticObjectFactory(ISemanticObjectFactory factory) {
        this._objectFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundEObject getSemanticModel(Node target) {
        Object object = this._lock;
        synchronized (object) {
            BoundEObject obj = this._model.get(target);
            if (obj == null && (obj = this._objectFactory.createBoundEObject(target)) != null) {
                this._model.put(target, obj);
                this._emfResource.getContents().add((Object)obj);
            }
            return obj;
        }
    }

    public boolean isAdapterForType(Object type) {
        return ISemanticModelServiceAdapter.class.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this._lock;
        synchronized (object) {
            for (Map.Entry<Node, BoundEObject> entry : this._model.entrySet()) {
                BoundEObject value = entry.getValue();
                value.eAdapters().clear();
            }
            this._model.clear();
            this._domModelHolder.dispose();
            this._emfResource.getContents().clear();
        }
    }

    static class DOMModelHolder {
        private final IDOMModel _model;
        private final boolean _releaseOnDispose;
        private final IFile _file;

        public DOMModelHolder(IDOMModel model) {
            this._model = model;
            this._releaseOnDispose = false;
            this._file = this.getFile(model);
            if (this._file == null) {
                throw new IllegalArgumentException("model must have an associated IFile");
            }
        }

        public DOMModelHolder(IFile file) throws IOException, CoreException {
            this._file = file;
            this._model = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(file);
            this._releaseOnDispose = true;
        }

        public void dispose() {
            if (this._releaseOnDispose) {
                this._model.releaseFromRead();
            }
        }

        public IFile getFile() {
            return this._file;
        }

        public IDOMModel getModel() {
            return this._model;
        }

        private IFile getFile(IDOMModel model) {
            IResource resource;
            IStructuredDocument doc = model.getStructuredDocument();
            IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)doc, -1);
            IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context);
            if (resolver != null && (resource = resolver.getResource()).getType() == 1) {
                return (IFile)resource;
            }
            return null;
        }
    }
}

