/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.tlei;

import oracle.eclipse.tools.xml.model.metadata.tlei.ActionResultExportType;
import oracle.eclipse.tools.xml.model.metadata.tlei.ActionServletContextType;
import oracle.eclipse.tools.xml.model.metadata.tlei.DependencyType;
import oracle.eclipse.tools.xml.model.metadata.tlei.ECoreAnnotations;
import oracle.eclipse.tools.xml.model.metadata.tlei.InclusionUriType;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypeVariations;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.metadata.tlei.TagAttributeMarkers;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;

public final class TleiEcoreMetaData {
    public static final TleiEcoreMetaData INSTANCE = new TleiEcoreMetaData();

    public SubTypes getSubtype(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)ECoreAnnotations.SUB_TYPE.getLiteral());
            if (value == null) {
                return null;
            }
            SubTypes type = SubTypes.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown subtype: " + value);
            }
            return type;
        }
        return null;
    }

    public SubTypeVariations getSubTypeVariation(EStructuralFeature feature) {
        String value;
        SubTypes subType = this.getSubtype(feature);
        if (subType != SubTypes.URI_SUBTYPE) {
            return null;
        }
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null && (value = (String)annotation.getDetails().get((Object)ECoreAnnotations.SUB_TYPE_VARIATION.getLiteral())) != null) {
            SubTypeVariations type = SubTypeVariations.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown subtype variation: " + value);
            }
            return type;
        }
        return null;
    }

    public void setSubtype(EStructuralFeature feature, SubTypes value) {
        EAnnotation annotation = this.createAnnotation(feature);
        annotation.getDetails().put((Object)ECoreAnnotations.SUB_TYPE.getLiteral(), (Object)value.getLiteral());
    }

    public void setDependencyType(EStructuralFeature feature, DependencyType value) {
        EAnnotation annotation = this.createAnnotation(feature);
        annotation.getDetails().put((Object)ECoreAnnotations.DEPENDENCY_TYPE.getLiteral(), (Object)value.getLiteral());
    }

    private EAnnotation createAnnotation(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://oracle.com/eclipse/tools/metadata/tlei");
            feature.getEAnnotations().add((Object)annotation);
        }
        return annotation;
    }

    private EAnnotation createAnnotation(EClassifier classifier) {
        EAnnotation annotation = classifier.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation == null) {
            annotation = EcoreFactory.eINSTANCE.createEAnnotation();
            annotation.setSource("http://oracle.com/eclipse/tools/metadata/tlei");
            classifier.getEAnnotations().add((Object)annotation);
        }
        return annotation;
    }

    public void setSubtypeVariation(EStructuralFeature feature, SubTypeVariations subTypeVariations) {
        EAnnotation annotation = this.createAnnotation(feature);
        annotation.getDetails().put((Object)ECoreAnnotations.SUB_TYPE_VARIATION.getLiteral(), (Object)subTypeVariations.getLiteral());
    }

    public InclusionUriType getInclusionUriType(EStructuralFeature feature) {
        String value;
        if (!this.isUriSubtype(feature)) {
            return null;
        }
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null && (value = (String)annotation.getDetails().get((Object)ECoreAnnotations.INCLUSION_URI.getLiteral())) != null) {
            InclusionUriType type = InclusionUriType.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown subtype variation: " + value);
            }
            return type;
        }
        return null;
    }

    public ActionResultExportType getActionResultExportType(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)ECoreAnnotations.ACTION_RESULT_EXPORT.getLiteral());
            if (value == null) {
                return null;
            }
            ActionResultExportType type = ActionResultExportType.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown action result export type: " + value);
            }
            return type;
        }
        return null;
    }

    public ActionServletContextType getActionServletContextType(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)ECoreAnnotations.ACTION_SERVLET_CONTEXT.getLiteral());
            if (value == null) {
                return null;
            }
            ActionServletContextType type = ActionServletContextType.get(value);
            if (type == null) {
                throw new IllegalStateException("Unknown ActionServletContextType: " + value);
            }
            return type;
        }
        return null;
    }

    public void setInclusionUriType(EStructuralFeature feature, InclusionUriType inclusionUriType) {
        if (!this.isUriSubtype(feature)) {
            throw new IllegalArgumentException("Can only set inclusionUriType on a uri subtyped attribute");
        }
        EAnnotation annotation = this.createAnnotation(feature);
        annotation.getDetails().put((Object)ECoreAnnotations.INCLUSION_URI.getLiteral(), (Object)inclusionUriType.getLiteral());
    }

    public boolean isInclusionUriType(EStructuralFeature feature) {
        if (this.isUriSubtype(feature)) {
            return this.getInclusionUriType(feature) != null;
        }
        return false;
    }

    private boolean isUriSubtype(EStructuralFeature feature) {
        SubTypes subType = this.getSubtype(feature);
        return subType == SubTypes.URI_SUBTYPE;
    }

    public String getTagAttributeMarker(EClass eClass, TagAttributeMarkers marker) {
        EAnnotation annotation = eClass.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)marker.getLiteral());
        }
        return null;
    }

    public String getRuntimeTypeDelegate(EDataType dataType) {
        EAnnotation annotation = dataType.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            return (String)annotation.getDetails().get((Object)ECoreAnnotations.DELEGATE_TO_RUNTIME_TYPE.getLiteral());
        }
        return null;
    }

    public String getHelpId(EClass eClass, String prefix) {
        String helpId = this.getHelpId(eClass);
        if (helpId != null) {
            return String.valueOf(prefix) + helpId;
        }
        return null;
    }

    public String getHelpId(EClass eClass) {
        EAnnotation annotation = eClass.getEAnnotation("http://oracle.com/eclipse/tools/metadata/tlei");
        if (annotation != null) {
            String helpId = (String)annotation.getDetails().get((Object)ECoreAnnotations.HELP_ID.getLiteral());
            if (helpId == null) {
                return null;
            }
            return helpId;
        }
        return null;
    }

    public void setHelpId(EClass eClass, String helpId) {
        EAnnotation annotation = this.createAnnotation((EClassifier)eClass);
        annotation.getDetails().put((Object)ECoreAnnotations.HELP_ID.getLiteral(), (Object)helpId);
    }

    private TleiEcoreMetaData() {
    }
}

