/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.tlei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DependencyType implements Enumerator
{
    FILE_REFERENCE(0, "FILE_REFERENCE", "file-reference"),
    FILE_DEPENDENCY(1, "FILE_DEPENDENCY", "file-dependency");

    public static final int FILE_REFERENCE_VALUE = 0;
    public static final int FILE_DEPENDENCY_VALUE = 1;
    private static final DependencyType[] VALUES_ARRAY;
    public static final List<DependencyType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DependencyType[]{FILE_REFERENCE, FILE_DEPENDENCY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DependencyType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DependencyType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DependencyType get(int value) {
        switch (value) {
            case 0: {
                return FILE_REFERENCE;
            }
            case 1: {
                return FILE_DEPENDENCY;
            }
        }
        return null;
    }

    private DependencyType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

