/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata.tlei;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContentFormatType implements Enumerator
{
    NONE(0, "none", "none"),
    WRAP_INDENT(1, "wrapIndent", "wrap-indent"),
    WRAP(2, "wrap", "wrap");

    public static final int NONE_VALUE = 0;
    public static final int WRAP_INDENT_VALUE = 1;
    public static final int WRAP_VALUE = 2;
    private static final ContentFormatType[] VALUES_ARRAY;
    public static final List<ContentFormatType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContentFormatType[]{NONE, WRAP_INDENT, WRAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContentFormatType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContentFormatType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContentFormatType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContentFormatType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContentFormatType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return WRAP_INDENT;
            }
            case 2: {
                return WRAP;
            }
        }
        return null;
    }

    private ContentFormatType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

