/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.metadata;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.xml.model.dynpkg.AbstractDynamicEPackage;
import oracle.eclipse.tools.xml.model.metadata.IChooseable;
import oracle.eclipse.tools.xml.model.metadata.impl.DCSFactoryMapper;
import oracle.eclipse.tools.xml.model.metadata.impl.TleiMetaData;
import oracle.eclipse.tools.xml.model.metadata.tlei.DependencyType;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypeVariations;
import oracle.eclipse.tools.xml.model.metadata.tlei.SubTypes;
import oracle.eclipse.tools.xml.model.metadata.tlei.TleiMetadataValuesType;
import oracle.eclipse.tools.xml.model.service.IXMLMetadataContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.IMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public final class TleiAccess {
    private static final String TRAIT_KEY_TLEI_SUBTYPE = "tlei";
    public static final TleiAccess INSTANCE = new TleiAccess();
    private final ConcurrentMap<TleiKey, SubTypes> _subtypeMap = new ConcurrentHashMap<TleiKey, SubTypes>(1024);

    private TleiAccess() {
    }

    public SubTypes getSubtype(IDocument document, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (document == null || !this.isDynamicPackage(feature)) {
            return this.getSubtypeFromEcore(feature);
        }
        return this.getSubtypeFromMetadata(document, feature);
    }

    public SubTypes getSubtype(IXMLMetadataContext context, EStructuralFeature feature) {
        return this.getSubtype(context, null, feature);
    }

    public SubTypes getSubtype(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (context == null || !this.isDynamicPackage(feature)) {
            return this.getSubtypeFromEcore(feature);
        }
        return this.getSubtypeFromMetadata(context, model, feature);
    }

    public SubTypeVariations getVariation(IDocument document, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (document == null || !this.isDynamicPackage(feature)) {
            return this.getVariationFromEcore(feature);
        }
        return this.getVariationFromMetadata(document, feature);
    }

    public SubTypeVariations getVariation(IXMLMetadataContext context, EStructuralFeature feature) {
        return this.getVariation(context, null, feature);
    }

    public SubTypeVariations getVariation(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (context == null || !this.isDynamicPackage(feature)) {
            return this.getVariationFromEcore(feature);
        }
        return this.getVariationFromMetadata(context, model, feature);
    }

    public String getDCSFactory(IDocument document, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (document == null || !this.isDynamicPackage(feature)) {
            return this.getDCSFactoryFromEcore(feature);
        }
        return this.getDCSFactoryFromMetadata(document, feature);
    }

    public String getDCSFactory(IXMLMetadataContext context, EStructuralFeature feature) {
        return this.getDCSFactory(context, null, feature);
    }

    public String getDCSFactory(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (context == null || !this.isDynamicPackage(feature)) {
            return this.getDCSFactoryFromEcore(feature);
        }
        return this.getDCSFactoryFromMetadata(context, model, feature);
    }

    public DependencyType getDependencyType(IDocument document, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (document == null || !this.isDynamicPackage(feature)) {
            return this.getDependencyTypeFromEcore(feature);
        }
        return this.getDependencyTypeFromMetadata(document, feature);
    }

    public DependencyType getDependencyType(IXMLMetadataContext context, EStructuralFeature feature) {
        return this.getDependencyType(context, null, feature);
    }

    public DependencyType getDependencyType(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        Assert.isNotNull((Object)feature);
        if (context == null || !this.isDynamicPackage(feature)) {
            return this.getDependencyTypeFromEcore(feature);
        }
        return this.getDependencyTypeFromMetadata(context, model, feature);
    }

    private SubTypes getSubtypeFromMetadata(IDocument document, EStructuralFeature feature) {
        TleiKey key = new TleiKey(feature);
        SubTypes subtype = (SubTypes)((Object)this._subtypeMap.get(key));
        if (subtype == SubTypes.UNSET) {
            return null;
        }
        if (subtype != null) {
            return subtype;
        }
        IChooseable chooseable = this.getChooseable(document, feature);
        subtype = chooseable == null ? null : chooseable.getSubtype();
        this._subtypeMap.putIfAbsent(key, subtype == null ? SubTypes.UNSET : subtype);
        return subtype;
    }

    private SubTypeVariations getVariationFromMetadata(IDocument document, EStructuralFeature feature) {
        IChooseable chooseable = this.getChooseable(document, feature);
        return chooseable == null ? null : chooseable.getVariation();
    }

    private String getDCSFactoryFromMetadata(IDocument document, EStructuralFeature feature) {
        IChooseable chooseable = this.getChooseable(document, feature);
        return chooseable == null ? null : chooseable.getDCSFactory();
    }

    private DependencyType getDependencyTypeFromMetadata(IDocument document, EStructuralFeature feature) {
        SubTypes subtype = this.getSubtypeFromMetadata(document, feature);
        return this.getDependencyType(subtype);
    }

    private DependencyType getDependencyType(SubTypes subtype) {
        if (SubTypes.URI_SUBTYPE.equals((Object)subtype) || SubTypes.IMAGE_URI_SUBTYPE.equals((Object)subtype) || SubTypes.XML_URI_SUBTYPE.equals((Object)subtype) || SubTypes.ADF_URI_SUBTYPE.equals((Object)subtype)) {
            return DependencyType.FILE_REFERENCE;
        }
        return null;
    }

    private String getDCSFactoryFromMetadata(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        IChooseable chooseable = this.getChooseable(context, model, feature);
        return chooseable == null ? null : chooseable.getDCSFactory();
    }

    private IChooseable getChooseable(IDocument document, EStructuralFeature feature) {
        org.eclipse.jface.text.IDocument jfaceDoc = (org.eclipse.jface.text.IDocument)document.getAdapter(org.eclipse.jface.text.IDocument.class);
        if (jfaceDoc == null) {
            return null;
        }
        IStructuredDocumentContext sdContext = IStructuredDocumentContextFactory.INSTANCE.getContext(jfaceDoc, 0);
        List mdFeatures = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IChooseable.class, sdContext, this.getPackageNsUri(feature), this.getTagName(feature), this.getAttributeName(feature));
        if (mdFeatures.size() == 0) {
            return null;
        }
        IMetaDataEnabledFeature mdFeature = (IMetaDataEnabledFeature)mdFeatures.get(0);
        if (!(mdFeature instanceof IChooseable)) {
            return null;
        }
        return (IChooseable)mdFeature;
    }

    private SubTypes getSubtypeFromMetadata(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        IChooseable chooseable;
        TleiKey key = new TleiKey(feature);
        SubTypes subtype = (SubTypes)((Object)this._subtypeMap.get(key));
        if (subtype == SubTypes.UNSET) {
            return null;
        }
        if (subtype != null) {
            return subtype;
        }
        subtype = model != null ? ((chooseable = this.getChooseable(context, model, feature)) == null ? null : chooseable.getSubtype()) : this.getSubtypeDirectlyFromMd(context, feature);
        this._subtypeMap.putIfAbsent(key, subtype == null ? SubTypes.UNSET : subtype);
        return subtype;
    }

    private SubTypes getSubtypeDirectlyFromMd(IXMLMetadataContext context, EStructuralFeature feature) {
        Object subtype;
        EObject value;
        Trait trait = this.getTrait(context, feature, TRAIT_KEY_TLEI_SUBTYPE);
        if (trait != null && (value = trait.getValue()) instanceof TleiMetadataValuesType && (subtype = ((TleiMetadataValuesType)value).getSubtype()) instanceof String) {
            return SubTypes.get((String)subtype);
        }
        return null;
    }

    private Trait getTrait(IXMLMetadataContext context, EStructuralFeature feature, String traitName) {
        EPackage ePackage;
        String attrName = ExtendedMetaData.INSTANCE.getName(feature);
        if (attrName == null) {
            return null;
        }
        EClass eContainingClass = feature.getEContainingClass();
        if (eContainingClass == null) {
            return null;
        }
        String elementName = ExtendedMetaData.INSTANCE.getName((EClassifier)eContainingClass);
        if (elementName == null) {
            return null;
        }
        if (elementName.indexOf("_._type") > -1) {
            elementName = elementName.substring(0, elementName.indexOf("_._type"));
        }
        if ((ePackage = eContainingClass.getEPackage()) == null) {
            return null;
        }
        String uri = ePackage.getNsURI();
        if (uri == null) {
            return null;
        }
        String entityKey = String.valueOf(elementName) + "/" + attrName;
        IMetaDataDomainContext mdContext = context.getMetaDataDomainContext();
        IMetaDataQuery query = MetaDataQueryFactory.getInstance().createQuery(mdContext);
        Entity entity = query.getQueryHelper().getEntity(uri, entityKey);
        return query.getQueryHelper().getTrait(entity, traitName);
    }

    private SubTypeVariations getVariationFromMetadata(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        IChooseable chooseable = this.getChooseable(context, model, feature);
        return chooseable == null ? null : chooseable.getVariation();
    }

    private DependencyType getDependencyTypeFromMetadata(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        SubTypes subtype = this.getSubtypeFromMetadata(context, model, feature);
        return this.getDependencyType(subtype);
    }

    private IChooseable getChooseable(IXMLMetadataContext context, IStructuredModel model, EStructuralFeature feature) {
        List<IMetaDataEnabledFeature> mdFeatures = context.getMetaDataFeature(IChooseable.class, this.getPackageNsUri(feature), this.getTagName(feature), this.getAttributeName(feature), -1, model);
        if (mdFeatures.size() == 0) {
            return null;
        }
        IMetaDataEnabledFeature mdFeature = mdFeatures.get(0);
        if (!(mdFeature instanceof IChooseable)) {
            return null;
        }
        return (IChooseable)mdFeature;
    }

    private String getPackageNsUri(EStructuralFeature feature) {
        return feature.getEContainingClass().getEPackage().getNsURI();
    }

    private String getTagName(EStructuralFeature feature) {
        String tagClassName = feature.getEContainingClass().getName();
        int suffixIndex = tagClassName.lastIndexOf("Type");
        if (suffixIndex == -1) {
            suffixIndex = tagClassName.lastIndexOf("Tag");
        }
        if (suffixIndex == -1) {
            suffixIndex = tagClassName.length();
        }
        StringBuilder builder = new StringBuilder(tagClassName.substring(0, suffixIndex));
        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        return builder.toString();
    }

    private String getAttributeName(EStructuralFeature feature) {
        return feature.getName();
    }

    public SubTypes getSubtypeFromEcore(EStructuralFeature feature) {
        return TleiMetaData.INSTANCE.getSubtype(feature);
    }

    private SubTypeVariations getVariationFromEcore(EStructuralFeature feature) {
        return TleiMetaData.INSTANCE.getSubTypeVariation(feature);
    }

    private String getDCSFactoryFromEcore(EStructuralFeature feature) {
        SubTypes subtype = this.getSubtypeFromEcore(feature);
        SubTypeVariations variation = this.getVariationFromEcore(feature);
        if (subtype == null) {
            return null;
        }
        return DCSFactoryMapper.INSTANCE.getDCSFactory(subtype, variation);
    }

    private DependencyType getDependencyTypeFromEcore(EStructuralFeature feature) {
        return TleiMetaData.INSTANCE.getDependencyType(feature);
    }

    public boolean isDynamicPackage(EStructuralFeature feature) {
        return this.isDynamicPackage(feature.getEContainingClass());
    }

    public boolean isDynamicPackage(EClass eClass) {
        return this.isDynamicPackage(eClass.getEPackage());
    }

    public boolean isDynamicPackage(EPackage ePackage) {
        return ePackage instanceof AbstractDynamicEPackage;
    }

    private static final class TleiKey {
        private final String _tagLibUri;
        private final String _tagName;
        private final String _attrName;
        private final int _hashCode;

        private TleiKey(EStructuralFeature feature) {
            this._attrName = feature.getName();
            EClass eClass = feature.getEContainingClass();
            this._tagName = eClass.getName();
            this._tagLibUri = eClass.getEPackage().getNsURI();
            this._hashCode = this.calculateHash();
        }

        private int calculateHash() {
            int result = 17;
            result = 31 * result + (this._tagLibUri == null ? 0 : this._tagLibUri.hashCode());
            result = 31 * result + (this._tagName == null ? 0 : this._tagName.hashCode());
            result = 31 * result + (this._attrName == null ? 0 : this._attrName.hashCode());
            return result;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TleiKey)) {
                return false;
            }
            TleiKey other = (TleiKey)obj;
            return (this._tagLibUri == null ? other._tagLibUri == null : this._tagLibUri.equals(other._tagLibUri)) && (this._tagName == null ? other._tagName == null : this._tagName.equals(other._tagName)) && (this._attrName == null ? other._attrName == null : this._attrName.equals(other._attrName));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append('(');
            builder.append(this._tagLibUri);
            builder.append(',');
            builder.append(this._tagName);
            builder.append(',');
            builder.append(this._attrName);
            builder.append(')');
            return builder.toString();
        }
    }
}

