/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import oracle.eclipse.tools.xml.model.emfbinding.dom.AbstractLoadFromDOMResource;
import oracle.eclipse.tools.xml.model.emfbinding.dom.StructuredModelXMLDocumentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.xml.sax.InputSource;

public class LoadStructuredModelAndBindResource
extends AbstractLoadFromDOMResource {
    private final StructuredModelXMLDocumentProvider _provider;

    public LoadStructuredModelAndBindResource(URI uri, StructuredModelXMLDocumentProvider provider) {
        super(uri);
        this._provider = provider;
    }

    @Override
    protected void doUnload() {
        try {
            super.doUnload();
        }
        finally {
            this._provider.release();
        }
    }

    public void load(Map<?, ?> options) throws IOException {
        URI uri_ = this.getURI();
        System.out.println(uri_);
        IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(uri_.toPlatformString(true));
        if (findMember.exists() && findMember.getType() == 1) {
            IFile loadFile = (IFile)findMember;
            this._backingDocument = this._provider.getXMLDocument(loadFile);
            if (this._backingDocument != null) {
                this.doLoad(this._backingDocument, options);
                return;
            }
            this.throwWrappingIOException("Error loading: " + this.getURI().toString(), this._provider.getLoadProblem());
        }
        throw new FileNotFoundException("Could not find file for uri: " + this.getURI().toString());
    }

    @Override
    public void doLoad(InputSource inputSource, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException("Must load through load(Map<?,?): " + this.getURI().toFileString());
    }

    @Override
    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        throw new UnsupportedOperationException("Must load through load(Map<?,?): " + this.getURI().toFileString());
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.doSave(options);
    }

    public void doSave(Writer writer, Map<?, ?> options) throws IOException {
        this.doSave(options);
    }

    public void save(Map<?, ?> options) throws IOException {
        this.doSave(options);
    }

    private void doSave(Map<?, ?> options) throws IOException {
        this._provider.saveXMLDocument();
        if (this._provider.getLoadProblem() != null) {
            this.throwWrappingIOException("Error saving: " + this.getURI().toString(), this._provider.getLoadProblem());
        }
    }
}

