/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.xml.model.emfbinding.AbstractBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.BoundEObject;
import oracle.eclipse.tools.xml.model.emfbinding.DiagnosticAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.DiagnosticFacade;
import oracle.eclipse.tools.xml.model.emfbinding.IBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.BasicEcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.ConversionResult;
import oracle.eclipse.tools.xml.model.emfbinding.dom.EcoreNodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INamespaceContext;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeBindingAdapter;
import oracle.eclipse.tools.xml.model.emfbinding.dom.INodeReader;
import oracle.eclipse.tools.xml.model.emfbinding.dom.NodeReader;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BasicNodeBindingAdapter
extends AbstractBindingAdapter
implements INodeBindingAdapter {
    private static final String EDATA_TYPE_VALIDATOR_SOURCE = "EDataTypeValidator";
    private static final DOMHandler DOMHANDLER = new DOMHandler();
    private final XMLHelper _helper = new XMLHelperImpl();
    private final Node _boundNode;
    private final BoundEObject _boundObject;
    private FeatureMap _childFeatures;
    private final INamespaceContext _namespaceContext;
    private EcoreNodeReader _ecoreReader;
    private final INodeReader _nodeReader;

    public BasicNodeBindingAdapter(BoundEObject boundObject, Node boundNode, INamespaceContext namespaceContext) {
        this._boundNode = boundNode;
        this._boundObject = boundObject;
        this._nodeReader = NodeReader.INSTANCE;
        this._namespaceContext = namespaceContext;
        this._ecoreReader = new BasicEcoreNodeReader(this._nodeReader, namespaceContext);
    }

    @Override
    public Collection<String> getRawInvalidValue(EStructuralFeature feature) {
        return null;
    }

    @Override
    public boolean isSetInvalid(EStructuralFeature feature) {
        return false;
    }

    @Override
    public Object getFeature(EStructuralFeature feature) {
        int kind = ExtMD.getFeatureKind(feature);
        String name = ExtMD.getName(feature);
        ConversionResult result = new ConversionResult();
        Object value = null;
        switch (kind) {
            case 2: {
                this.clearProblem(this._boundObject, EDATA_TYPE_VALIDATOR_SOURCE, feature);
                value = this._ecoreReader.getValue(this._boundNode, feature, result);
                break;
            }
            case 5: 
            case 6: {
                value = this.handleGetElementWildcard(kind, feature);
                break;
            }
            case 4: {
                this.clearProblem(this._boundObject, EDATA_TYPE_VALIDATOR_SOURCE, feature);
                value = this.handleGetElement(feature, name, result);
            }
        }
        if (value == EcoreNodeReader.INVALID_VALUE) {
            this.addProblem(this._boundNode, this._boundObject, EDATA_TYPE_VALIDATOR_SOURCE, result.getThrowable(), feature);
            value = feature.getDefaultValue();
        }
        return value;
    }

    private Object handleGetElement(EStructuralFeature feature, String name, ConversionResult result) {
        EClassifier eClassifier = feature.getEType();
        if (eClassifier instanceof EClass) {
            this.handleEClassElementGet(feature, (EClass)feature.getEType(), name);
        } else {
            this.handleEDataTypeGet(feature, name, result);
        }
        EList list = this.getChildFeatures().list(feature);
        if (feature.isMany()) {
            return list;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private void handleEDataTypeGet(EStructuralFeature feature, String name, ConversionResult result) {
        this.clearProblem(this._boundObject, EDATA_TYPE_VALIDATOR_SOURCE, feature);
        Object value = this._ecoreReader.getValue(this._boundNode, feature, result);
        if (value == EcoreNodeReader.INVALID_VALUE) {
            this.addProblem(this._boundNode, this._boundObject, EDATA_TYPE_VALIDATOR_SOURCE, result.getThrowable(), feature);
            value = feature.getDefaultValue();
        }
        if (feature.isMany()) {
            List listValue = (List)value;
            for (Object setValue : listValue) {
                this.setChildFeature(feature, setValue);
            }
        } else {
            this.setChildFeature(feature, value);
        }
    }

    private void handleEClassElementGet(EStructuralFeature feature, EClass eClass, String name) {
        NodeList nodes = this._boundNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String tagName;
            Node child = nodes.item(i);
            if (child != null && child.getNodeType() == 1 && (tagName = this._nodeReader.getElementQName((Element)child)) != null && tagName.equals(name)) {
                this.handleEClassGet(feature, child, eClass);
            }
            ++i;
        }
    }

    private void addProblem(Node node, EObject eobj, String source, Throwable throwable, EStructuralFeature feature) {
        Resource.Diagnostic diag = null;
        if (throwable instanceof Resource.Diagnostic) {
            diag = (Resource.Diagnostic)throwable;
        } else if (node instanceof IDOMNode) {
            diag = new DiagnosticFacade((Diagnostic)new BasicDiagnostic(source, -1, throwable.getLocalizedMessage(), new Object[]{throwable}), (IDOMNode)node, eobj, feature);
        } else {
            throw new IllegalStateException("We don't support this case yet.");
        }
        DiagnosticAdapter.addDiagnostic(eobj, diag);
    }

    private void clearProblem(EObject eobj, String source, EStructuralFeature feature) {
        DiagnosticAdapter.clearDiagnostics(source, eobj, feature);
    }

    private void setChildFeature(EStructuralFeature feature, Object value) {
        boolean oldValue = this._boundObject.getUpdateBoundData();
        try {
            this._boundObject.setUpdateBoundData(false);
            this.getChildFeatures().add(feature, value);
        }
        finally {
            this._boundObject.setUpdateBoundData(oldValue);
        }
    }

    private void handleEClassGet(EStructuralFeature feature, Node child, EClass type) {
        EObject childEObject = this.findChildEObject(feature, child);
        if (childEObject == null) {
            EFactory factory = type.getEPackage().getEFactoryInstance();
            childEObject = this._helper.createObject(factory, (EClassifier)type);
            this.setChildFeature(feature, childEObject);
            if (childEObject instanceof BoundEObject) {
                ((BoundEObject)childEObject).bind(new BasicNodeBindingAdapter((BoundEObject)childEObject, child, this._namespaceContext), true);
            }
        }
    }

    private FeatureMap handleGetElementWildcard(int kind, EStructuralFeature feature) {
        int contentKind = ExtMD.getContentKind(this._boundObject.eClass());
        FeatureMap fMap = (FeatureMap)this.getChildFeatures().get(feature, false);
        switch (contentKind) {
            case 3: {
                NodeList nodeList = this._boundNode.getChildNodes();
                StringBuffer buffer = new StringBuffer();
                boolean hasText = false;
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() == 3) {
                        buffer.append(node.getNodeValue());
                        hasText = true;
                    }
                    ++i;
                }
                EAttribute textFeature = XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT;
                if (textFeature == null) break;
                if (fMap.isSet((EStructuralFeature)textFeature)) {
                    fMap.unset((EStructuralFeature)textFeature);
                }
                if (!hasText) break;
                EObject ownerObject = ((FeatureMap.Internal)fMap).getEObject();
                boolean curDeliver = ownerObject.eDeliver();
                ownerObject.eSetDeliver(false);
                try {
                    fMap.add((EStructuralFeature)textFeature, (Object)buffer.toString());
                }
                finally {
                    ownerObject.eSetDeliver(curDeliver);
                }
            }
        }
        return fMap;
    }

    @Override
    public INamespaceContext getNamespaceContext() {
        return this._namespaceContext;
    }

    public final void assertIsCorrectNodeBinding(EObject check) {
    }

    @Override
    public void setFeature(EStructuralFeature feature, Object value) {
        int kind = ExtMD.getFeatureKind(feature);
        String name = ExtMD.getName(feature);
        switch (kind) {
            case 2: {
                Node node = this._boundNode.getAttributes().getNamedItem(name);
                if (node == null) {
                    if (value == null) break;
                    Attr newAttr = this._boundNode.getOwnerDocument().createAttribute(name);
                    newAttr.setNodeValue(value.toString());
                    this._boundNode.getAttributes().setNamedItem(newAttr);
                    break;
                }
                if (node.getNodeType() == 2) {
                    if (value != null) {
                        Attr attr = (Attr)node;
                        attr.setValue(value.toString());
                        break;
                    }
                    this._boundNode.getAttributes().removeNamedItem(name);
                    break;
                }
                throw new IllegalStateException(String.format("Expected an attribute but found %d, for feature: %s", node.getNodeType(), feature.toString()));
            }
            case 5: 
            case 6: {
                this.handleSetElementWildcard(kind, feature, value);
                break;
            }
            case 4: {
                this.handleSetElement(feature, name, value);
            }
        }
    }

    private void handleSetElement(EStructuralFeature feature, String name, Object newValue) {
        if (feature.isMany()) {
            this.handleSetManyElement(feature, name, newValue);
        } else {
            this.handleSetSingleElement(feature, name, newValue);
        }
    }

    private void handleSetManyElement(EStructuralFeature feature, String name, Object newValue) {
        if (!feature.isMany()) {
            throw new IllegalArgumentException("feature must be isMany" + feature);
        }
        ConversionResult result = new ConversionResult();
        EList featureValues = (EList)this.handleGetElement(feature, name, result);
        if (featureValues.isEmpty()) {
            List<Object> valuesList = null;
            valuesList = newValue instanceof List ? (List<Object>)newValue : Collections.singletonList(newValue);
            for (Object newFValue : valuesList) {
                if (!(newFValue instanceof EObject)) continue;
                this.handleSetSingleElement(feature, name, newFValue);
            }
        }
    }

    private void handleSetSingleElement(EStructuralFeature feature, String name, Object newValue) {
        ConversionResult result = new ConversionResult();
        Object featureValues = this.handleGetElement(feature, name, result);
        if (featureValues == null || feature.isMany() && ((EList)featureValues).isEmpty()) {
            this.getChildFeatures().add(feature, newValue);
        } else if (featureValues instanceof EObject) {
            EObject oldValue = (EObject)featureValues;
            Node existingNode = this.findNode(oldValue);
            if (existingNode != null) {
                if (newValue == null) {
                    this.removeChildElement(existingNode, feature, oldValue);
                } else {
                    this.getChildFeatures().list(feature).remove((Object)oldValue);
                    if (oldValue instanceof BoundEObject) {
                        ((BoundEObject)oldValue).unbind();
                    }
                    this.getChildFeatures().add(feature, newValue);
                }
            } else {
                this.getChildFeatures().add(feature, newValue);
            }
        } else if (feature.getEType() instanceof EDataType) {
            Object oldValue = this.getFeature(feature);
            if (!feature.isMany()) {
                if (oldValue != null || newValue == null) {
                    this.removeChildElement(this._boundNode, feature, oldValue);
                }
                if (newValue != null) {
                    this.getChildFeatures().add(feature, newValue);
                }
            } else {
                throw new UnsupportedOperationException("TODO: support this case");
            }
        }
    }

    private Node recursivelyBuildSubtree(Node node, EStructuralFeature feature, EObject newValue) {
        block5: for (EStructuralFeature childFeature : newValue.eClass().getEAllStructuralFeatures()) {
            if (childFeature.isDerived() || !newValue.eIsSet(childFeature)) continue;
            int kind = ExtMD.getFeatureKind(childFeature);
            String name = ExtMD.getName(childFeature);
            switch (kind) {
                case 2: {
                    Attr attr = this._boundNode.getOwnerDocument().createAttribute(name);
                    attr.setNodeValue(newValue.eGet(childFeature).toString());
                    node.getAttributes().setNamedItem(attr);
                    break;
                }
                case 4: {
                    Object childValue = newValue.eGet(childFeature);
                    if (childFeature.isMany()) {
                        if (!(childValue instanceof EList)) break;
                        EList children = (EList)childValue;
                        for (Object manyValue : children) {
                            this.createChildElement(node, childFeature, name, manyValue);
                        }
                        continue block5;
                    }
                    this.createChildElement(node, childFeature, name, childValue);
                    break;
                }
                case 5: 
                case 6: {
                    EStructuralFeature textFeature = this.getTextFeatureForGroup(childFeature);
                    if (textFeature == null) break;
                    Object text = newValue.eGet(textFeature);
                    Text textNode = this._boundNode.getOwnerDocument().createTextNode(text.toString());
                    node.appendChild(textNode);
                }
            }
        }
        if (newValue instanceof BoundEObject) {
            ((BoundEObject)newValue).bind(new BasicNodeBindingAdapter((BoundEObject)newValue, node, this._namespaceContext), false);
        }
        return node;
    }

    private Node createChildElement(Node node, EStructuralFeature childFeature, String name, Object childValue) {
        Element newChildNode = DOMHANDLER.createElement(this._boundNode.getOwnerDocument(), name);
        node.appendChild(newChildNode);
        if (childValue instanceof EObject) {
            this.recursivelyBuildSubtree(newChildNode, childFeature, (EObject)childValue);
        } else {
            DOMHANDLER.setTextContent(newChildNode, EcoreUtil.convertToString((EDataType)((EDataType)childFeature.getEType()), (Object)childValue));
        }
        return newChildNode;
    }

    private void removeChildElement(Node node, EStructuralFeature feature, Object oldValue) {
        if (oldValue != null) {
            ((FeatureMap.Internal)this.getChildFeatures()).remove(feature, oldValue);
            if (oldValue instanceof BoundEObject) {
                ((BoundEObject)oldValue).unbind();
            }
        }
    }

    private void handleSetElementWildcard(int kind, EStructuralFeature feature, Object newValue) {
        throw new UnsupportedOperationException();
    }

    protected void bindEventModel() {
    }

    @Override
    public Node getBoundItem() {
        return this._boundNode;
    }

    private EObject findChildEObject(EStructuralFeature feature, Node node) {
        EList list = this.getChildFeatures().list(feature);
        for (Object obj : list) {
            EObject eobj;
            IBindingAdapter adapter;
            if (!(obj instanceof EObject) || (adapter = (IBindingAdapter)EcoreUtil.getAdapter((List)(eobj = (EObject)obj).eAdapters(), IBindingAdapter.class)) == null || node != adapter.getBoundItem()) continue;
            return eobj;
        }
        return null;
    }

    private Node findNode(EObject eobj) {
        Object boundItem;
        IBindingAdapter adapter = (IBindingAdapter)EcoreUtil.getAdapter((List)eobj.eAdapters(), IBindingAdapter.class);
        if (adapter != null && (boundItem = adapter.getBoundItem()) instanceof Node) {
            NodeList list = this._boundNode.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                if (boundItem == list.item(i)) {
                    return (Node)boundItem;
                }
                ++i;
            }
        }
        return null;
    }

    private List<Node> removeNodes(EStructuralFeature feature) {
        String deleteAllWithName = ExtendedMetaData.INSTANCE.getName(feature);
        if (deleteAllWithName == null) {
            return Collections.emptyList();
        }
        NodeList childNodes = this._boundNode.getChildNodes();
        ArrayList<Node> removedNodes = new ArrayList<Node>();
        int i = 0;
        while (i < childNodes.getLength()) {
            String name;
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1 && deleteAllWithName.equals(name = this._nodeReader.getElementQName((Element)childNode))) {
                this._boundNode.removeChild(childNode);
                removedNodes.add(childNode);
            }
            ++i;
        }
        return removedNodes;
    }

    private FeatureMap getChildFeatures() {
        if (this._childFeatures == null) {
            this._childFeatures = new BoundObjectFeatureMap((InternalEObject)this._boundObject, -2);
        }
        return this._childFeatures;
    }

    public boolean isAdapterForType(Object type) {
        if (!IBindingAdapter.class.equals(type)) {
            return super.isAdapterForType(type);
        }
        return true;
    }

    @Override
    public void doDispose(boolean disposeChildren) {
        if (this._childFeatures != null) {
            if (disposeChildren) {
                for (FeatureMap.Entry next : this._childFeatures) {
                    Object value = next.getValue();
                    if (!(value instanceof BoundEObject)) continue;
                    ((BoundEObject)value).unbind();
                }
            }
            this._childFeatures.clear();
        }
    }

    private class BoundObjectFeatureMap
    extends BasicFeatureMap {
        private static final long serialVersionUID = -8283889358579659704L;

        public BoundObjectFeatureMap(InternalEObject owner, int featureID) {
            super(owner, featureID);
        }

        public BoundObjectFeatureMap(InternalEObject owner, int featureID, EStructuralFeature structuralFeature) {
            super(owner, featureID, structuralFeature);
        }

        public Object get(EStructuralFeature feature, boolean resolve) {
            if (!(!feature.isMany() || ExtMD.getFeatureKind(feature) != 6 && ExtMD.getFeatureKind(feature) != 5 || ExtMD.getContentKind(feature.getEContainingClass()) != 3 && ExtMD.getContentKind(this.owner.eClass()) != 3)) {
                return new MixedContentFeatureMap((InternalEObject)BasicNodeBindingAdapter.this._boundObject, feature.getFeatureID());
            }
            return super.get(feature, resolve);
        }

        private void internalHandleSet(int index, EStructuralFeature feature, Object newValue) {
            if (!BasicNodeBindingAdapter.this._boundObject.getUpdateBoundData()) {
                return;
            }
            if (newValue instanceof EObject) {
                EObject newEObj = (EObject)newValue;
                assert (BasicNodeBindingAdapter.this._boundObject == newEObj.eContainer());
                String name = ExtMD.getName(feature);
                Node node = this.replaceChildElement(name, feature, newEObj);
                BasicNodeBindingAdapter.this._boundNode.appendChild(node);
            } else if (feature.getEType() instanceof EDataType) {
                String name = ExtendedMetaData.INSTANCE.getName(feature);
                BasicNodeBindingAdapter.this.createChildElement(BasicNodeBindingAdapter.this._boundNode, feature, name, newValue);
            }
        }

        protected void didSet(int index, FeatureMap.Entry newObject, FeatureMap.Entry oldObject) {
            this.internalHandleSet(index, newObject.getEStructuralFeature(), newObject.getValue());
        }

        protected void didAdd(int index, FeatureMap.Entry newObject) {
            this.internalHandleSet(index, newObject.getEStructuralFeature(), newObject.getValue());
        }

        protected void didRemove(int index, FeatureMap.Entry oldObject) {
            if (!BasicNodeBindingAdapter.this._boundObject.getUpdateBoundData()) {
                return;
            }
            Object value = oldObject.getValue();
            if (value instanceof EObject) {
                EObject newEObj = (EObject)value;
                Node removeNode = BasicNodeBindingAdapter.this.findNode(newEObj);
                if (removeNode != null) {
                    BasicNodeBindingAdapter.this._boundNode.removeChild(removeNode);
                }
            } else if (oldObject.getEStructuralFeature().getEType() instanceof EDataType) {
                BasicNodeBindingAdapter.this.removeNodes(oldObject.getEStructuralFeature());
            }
        }

        private Node replaceChildElement(String name, EStructuralFeature feature, EObject newValue) {
            if (newValue == null) {
                throw new IllegalStateException("newValue can't be null");
            }
            Element newNode = DOMHANDLER.createElement(BasicNodeBindingAdapter.this._boundNode.getOwnerDocument(), name);
            return BasicNodeBindingAdapter.this.recursivelyBuildSubtree(newNode, feature, newValue);
        }
    }

    private static class DOMHandler {
        private DOMHandler() {
        }

        public Element createElement(Document ownerDocument, String name) {
            return ownerDocument.createElement(name);
        }

        public void setTextContent(Node node, String text) {
            this.replaceTextNodes(node, text);
        }

        private void replaceTextNodes(Node node, String newText) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 3) {
                    node.removeChild(child);
                }
                ++i;
            }
            node.appendChild(node.getOwnerDocument().createTextNode(newText));
        }
    }

    private class MixedContentFeatureMap
    extends BasicFeatureMap {
        private static final long serialVersionUID = -7151405116678652321L;

        public MixedContentFeatureMap(InternalEObject owner, int featureID) {
            super(owner, featureID);
        }

        public MixedContentFeatureMap(InternalEObject owner, int featureID, EStructuralFeature structuralFeature) {
            super(owner, featureID, structuralFeature);
        }

        public void set(EStructuralFeature feature, Object object) {
            super.set(feature, object);
            if (XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT.equals(feature)) {
                DOMHANDLER.setTextContent(BasicNodeBindingAdapter.this._boundNode, IBindingAdapter.UTIL.compressTextContent(feature, object));
            }
        }
    }
}

