/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding;

import oracle.eclipse.tools.xml.model.dynpkg.AbstractDynamicEPackage;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public final class ExtendedEcoreUtil {
    public static final ExtendedEcoreUtil INSTANCE = new ExtendedEcoreUtil();
    public static final String ECLASS_ELEMENT_NAME_SUFFIX = "_._type";

    public EClass findEClassForElement(String nodeName, String uri) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (ePackage != null) {
            return this.findEClassForElement(nodeName, ePackage);
        }
        return null;
    }

    public EClass findEClassForElement(IFile file, String nodeName, String uri) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(uri);
        if (ePackage != null) {
            if (ePackage instanceof AbstractDynamicEPackage) {
                return ((AbstractDynamicEPackage)ePackage).generateEClass(nodeName, file);
            }
            return this.findEClassForElement(nodeName, ePackage);
        }
        return null;
    }

    public EClass findEClassForElement(String nodeName, EPackage ePackage) {
        ExtendedMetaData extMd = ExtendedMetaData.INSTANCE;
        EClassifier type = extMd.getType(ePackage, this.getAnnotationName(nodeName));
        if (type instanceof EClass) {
            return (EClass)type;
        }
        return null;
    }

    public EStructuralFeature getFeature(IFile file, String uri, String tagName, String attrName) {
        EClass eClass = this.findEClassForElement(file, tagName, uri);
        if (eClass != null) {
            return ExtendedMetaData.INSTANCE.getAttribute(eClass, null, attrName);
        }
        return null;
    }

    public EStructuralFeature getFeature(String uri, String tagName, String attrName) {
        EClass eClass = this.findEClassForElement(tagName, uri);
        if (eClass != null) {
            return ExtendedMetaData.INSTANCE.getAttribute(eClass, null, attrName);
        }
        return null;
    }

    public String getAnnotationName(String elementName) {
        return String.valueOf(elementName) + ECLASS_ELEMENT_NAME_SUFFIX;
    }

    public String getNodeName(EClass eClass) {
        String nodeName = ExtendedMetaData.INSTANCE.getName((EClassifier)eClass);
        if (nodeName != null && nodeName.endsWith(ECLASS_ELEMENT_NAME_SUFFIX)) {
            nodeName = nodeName.substring(0, nodeName.indexOf("_._"));
        }
        return nodeName;
    }

    public String getNamespaceUri(EClass tag) {
        return tag.getEPackage().getNsURI();
    }

    public EStructuralFeature getTextContentFeature(EClass eClass) {
        EStructuralFeature found = null;
        for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
            if (!this.isTextContentFeature(feature)) continue;
            found = feature;
            break;
        }
        return found;
    }

    public boolean isTextContentFeature(EStructuralFeature feature) {
        return "ecore.xml.type:text".equals(ExtendedMetaData.INSTANCE.getName(feature));
    }
}

