/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.emfbinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.xml.model.emfbinding.IFeatureDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class DiagnosticAdapter {
    public static List<Diagnostic> getDiagnostics(Object object) {
        if (object instanceof EObject) {
            List<Diagnostic> diagnostics = DiagnosticAdapter.getDiagnostics("EDataTypeValidator", (EObject)object, null);
            return Collections.unmodifiableList(diagnostics);
        }
        return Collections.emptyList();
    }

    public static void addDiagnostic(EObject owner, Resource.Diagnostic diagnostic) {
        Resource res = owner.eResource();
        res.getErrors().add((Object)diagnostic);
    }

    public static void clearDiagnostics(String source, EObject owner, EStructuralFeature feature) {
        Resource res = owner.eResource();
        if (res == null) {
            return;
        }
        Iterator diagIt = res.getErrors().iterator();
        while (diagIt.hasNext()) {
            IFeatureDiagnostic featureDiag;
            Resource.Diagnostic diag = (Resource.Diagnostic)diagIt.next();
            if (!(diag instanceof IFeatureDiagnostic) || !source.equals((featureDiag = (IFeatureDiagnostic)diag).getSource()) || !owner.equals(featureDiag.getOwner()) || !feature.equals(featureDiag.getFeature())) continue;
            diagIt.remove();
        }
    }

    public static List<Diagnostic> getDiagnostics(String source, EObject owner, EStructuralFeature feature) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Resource res = owner.eResource();
        for (Resource.Diagnostic diag : res.getErrors()) {
            IFeatureDiagnostic featureDiag;
            if (!(diag instanceof Diagnostic) || !(diag instanceof IFeatureDiagnostic) || !source.equals((featureDiag = (IFeatureDiagnostic)diag).getSource()) || !owner.equals(featureDiag.getOwner()) || feature != null && !feature.equals(featureDiag.getFeature())) continue;
            diagnostics.add((Diagnostic)diag);
        }
        return diagnostics;
    }
}

