/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.xml.model.dynpkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.xml.model.TraceOptions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;

public class EClassGenerator {
    public static final String STRING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.StringType";
    public static final String BOOLEAN_TYPE = "org.eclipse.jst.jsf.core.attributevalues.BooleanType";
    public static final String INTEGER_TYPE = "org.eclipse.jst.jsf.core.attributevalues.IntegerType";
    public static final String LONG_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LongType";
    public static final String DOUBLE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.DoubleType";
    public static final String OBJECT_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ObjectType";
    public static final String COMPONENT_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ComponentIDType";
    public static final String ADF_ACTION_TYPE = "oracle.eclipse.tools.webtier.adf.attributevalues.ActionType";
    public static final String CSS_CLASS_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CSSClassType";
    public static final String CSS_STYLE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CSSStyleType";
    public static final String FACES_CONFIG_CONVERTER_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.FacesConfigConverterIDType";
    public static final String FACES_CONFIG_VALIDATOR_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.FacesConfigValidatorIDType";
    public static final String VALUE_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ValueBindingType";
    public static final String METHOD_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.MethodBindingType";
    public static final String COMPONENT_BINDING_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ComponentBindingType";
    public static final String BASE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.BaseType";
    public static final String JAVA_CLASS_TYPE = "org.eclipse.jst.jsf.core.attributevalues.JavaClassType";
    public static final String VALUE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ValueType";
    public static final String FACES_CONFIG_IDENTIFIER_TYPE = "org.eclipse.jst.jsf.core.attributevalues.FacesConfigIdentifierType";
    public static final String LENGTH_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LengthType";
    public static final String COLOR_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ColorType";
    public static final String RESOURCE_BUNDLE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ResourceBundleType";
    public static final String LANGUAGE_CODE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LanguageCodeType";
    public static final String RELATIVE_PATH_TYPE = "org.eclipse.jst.jsf.core.attributevalues.RelativePathType";
    public static final String WEB_PATH_TYPE = "org.eclipse.jst.jsf.core.attributevalues.WebPathType";
    public static final String CURRENCY_CODE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CurrencyCodeType";
    public static final String LOCALE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LocaleType";
    public static final String TIME_ZONE_TYPE = "org.eclipse.jst.jsf.core.attributevalues.TimeZoneType";
    public static final String DATE_TIME_PATTERN_TYPE = "org.eclipse.jst.jsf.core.attributevalues.DateTimePatternType";
    public static final String NUMBER_PATTERN_TYPE = "org.eclipse.jst.jsf.core.attributevalues.NumberPatternType";
    public static final String SCRIPT_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ScriptType";
    public static final String CHARACTER_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CharacterType";
    public static final String LINK_TYPE = "org.eclipse.jst.jsf.core.attributevalues.LinkType";
    public static final String CONTENT_TYPE = "org.eclipse.jst.jsf.core.attributevalues.ContentType";
    public static final String URI_TYPE = "org.eclipse.jst.jsf.core.attributevalues.URIType";
    public static final String CSS_ID_TYPE = "org.eclipse.jst.jsf.core.attributevalues.CSSIdType";
    private static final Map<String, EDataType> TYPE_MAP = new HashMap<String, EDataType>();
    private static final String TAG_CLASS_SUFFIX = "Type";
    private static final String TAG_CLASS_XMD_SUFFIX = "_._type";
    private static final String ENUM_SUFFIX = "_EnumType";
    private static final String ENUM_UNION_SUFFIX = "_EnumUnionType";
    private static final EcoreFactory ECORE_FACTORY;
    private final Map<IPath, IMetaDataDomainContext> _metadataDomainContexts = new HashMap<IPath, IMetaDataDomainContext>();
    private Map<EnumerationData, EDataType> _enumMap = new HashMap<EnumerationData, EDataType>();

    static {
        TYPE_MAP.put(BOOLEAN_TYPE, EcorePackage.Literals.EBOOLEAN_OBJECT);
        TYPE_MAP.put(INTEGER_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(LONG_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(DOUBLE_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(STRING_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(COMPONENT_ID_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(OBJECT_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(FACES_CONFIG_CONVERTER_ID_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(FACES_CONFIG_VALIDATOR_ID_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(ADF_ACTION_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(CSS_STYLE_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(CSS_CLASS_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(VALUE_BINDING_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(METHOD_BINDING_TYPE, XMLTypePackage.Literals.STRING);
        TYPE_MAP.put(COMPONENT_BINDING_TYPE, XMLTypePackage.Literals.STRING);
        ECORE_FACTORY = EcoreFactory.eINSTANCE;
    }

    protected EClass getSuperClass(EClass eClass) {
        return null;
    }

    private void setSuperClass(EClass eClass) {
        EClass superClass = this.getSuperClass(eClass);
        if (superClass != null) {
            EList superTypes = eClass.getESuperTypes();
            if (superTypes.size() == 0) {
                superTypes.add((Object)superClass);
            } else if (((EClass)superTypes.get(0)).isInterface()) {
                superTypes.add(0, (Object)superClass);
            } else {
                superTypes.remove(0);
                superTypes.add(0, (Object)superClass);
            }
        }
    }

    EClass generateEClass(EPackage ePackage, IFile file, String tagLibURI, String tagName) {
        String name;
        EClassifier existingClassifier;
        Entity tagEntity;
        if (TraceOptions.ESTORE) {
            TraceOptions.log("Entering EClassGenerator.generateEClass(" + ePackage + ", " + file + ", " + tagLibURI + ", " + tagName);
        }
        long startGetMetadata = 0L;
        if (TraceOptions.PERF) {
            startGetMetadata = System.nanoTime();
        }
        if ((tagEntity = this.getTagMetadata(file, tagLibURI, tagName)) == null) {
            return null;
        }
        if (TraceOptions.PERF) {
            long getMetadataTime = System.nanoTime() - startGetMetadata;
            TraceOptions.log("EClassGenerator_GetTagMetadata (" + file + ',' + tagLibURI + ',' + tagName + ')' + " time ns, " + getMetadataTime);
        }
        long startGenEClass = 0L;
        if (TraceOptions.PERF) {
            startGenEClass = System.nanoTime();
        }
        if ((existingClassifier = ePackage.getEClassifier(name = this.createTagClassName(tagEntity.getId()))) != null) {
            if (TraceOptions.PERF) {
                TraceOptions.log("There is already a classifier named '" + name + "' so this method is returning it");
            }
            return (EClass)existingClassifier;
        }
        EClass tagClass = ECORE_FACTORY.createEClass();
        this.setSuperClass(tagClass);
        tagClass.setName(name);
        ExtendedMetaData xmd = ExtendedMetaData.INSTANCE;
        for (Entity attr : tagEntity.getChildEntities()) {
            Trait attrType = this.getTrait(attr, TraitId.ATTRIBUTE_VALUE_RUNTIME_TYPE);
            EDataType emfAttrType = this.getEMFAttributeType(attrType);
            EAttribute emfAttr = ECORE_FACTORY.createEAttribute();
            emfAttr.setName(attr.getId());
            emfAttr.setEType((EClassifier)emfAttrType);
            tagClass.getEStructuralFeatures().add((Object)emfAttr);
            xmd.setName((EStructuralFeature)emfAttr, attr.getId());
            xmd.setFeatureKind((EStructuralFeature)emfAttr, 2);
            this.setEnumeration(tagClass, emfAttr, attr, ePackage);
            this.setDefaultValue(emfAttr, attr);
            this.setInitialValue(emfAttr, attr);
            this.setRequired(emfAttr, attr);
        }
        ePackage.getEClassifiers().add((Object)tagClass);
        xmd.setName((EClassifier)tagClass, this.createTagClassXMDName(tagEntity.getId()));
        xmd.setContentKind(tagClass, 3);
        if (TraceOptions.PERF) {
            long genEClassTime = System.nanoTime() - startGenEClass;
            TraceOptions.log("EClassGenerator_GenerateEClass (" + file + ',' + tagLibURI + ',' + tagName + ')' + " time ns, " + genEClassTime);
        }
        if (TraceOptions.ESTORE) {
            TraceOptions.log("Exiting EClassGenerator.generateEClass(" + ePackage + ", " + file + ", " + tagLibURI + ", " + tagName + ": Returning " + tagClass);
        }
        return tagClass;
    }

    protected void setEnumeration(EClass emfTag, EAttribute emfAttribute, Entity attrMetadata, EPackage ePackage) {
        Trait attrType = this.getTrait(attrMetadata, TraitId.VALID_VALUES);
        if (attrType == null) {
            return;
        }
        List values = TraitValueHelper.getValueAsListOfStrings((Trait)attrType);
        if (values.size() == 0) {
            return;
        }
        EnumerationData key = new EnumerationData(values);
        EDataType enumUnionType = this._enumMap.get(key);
        if (enumUnionType == null) {
            enumUnionType = this.createEnumeration(emfTag.getName(), emfAttribute.getName(), key, ePackage);
        }
        emfAttribute.setEType((EClassifier)enumUnionType);
    }

    protected EDataType createEnumeration(String tagName, String attributeName, EnumerationData data, EPackage ePackage) {
        Assert.isNotNull((Object)tagName);
        Assert.isNotNull((Object)attributeName);
        EEnum emfEnum = this.createEEnum(tagName, attributeName, data, ePackage);
        EDataType dataType = this.createEnumEDataType(tagName, attributeName, emfEnum.getName(), ePackage);
        this._enumMap.put(data, dataType);
        return dataType;
    }

    protected EDataType createEnumEDataType(String tagName, String attributeName, String enumName, EPackage ePackage) {
        EDataType dataType = EcoreFactory.eINSTANCE.createEDataType();
        String dataTypeName = this.createEnumName(tagName, attributeName, ENUM_UNION_SUFFIX);
        dataType.setName(dataTypeName);
        dataType.setInstanceClassName("java.lang.Object");
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("http:///org/eclipse/emf/ecore/util/ExtendedMetaData");
        annotation.getDetails().put((Object)"name", (Object)dataTypeName);
        annotation.getDetails().put((Object)"memberTypes", (Object)(String.valueOf(enumName) + " http://www.eclipse.org/emf/2003/XMLType#string"));
        annotation.getDetails().put((Object)"baseType", (Object)"http://www.eclipse.org/emf/2003/XMLType#anySimpleType");
        dataType.getEAnnotations().add((Object)annotation);
        ePackage.getEClassifiers().add((Object)dataType);
        return dataType;
    }

    protected EEnum createEEnum(String tagName, String attributeName, EnumerationData data, EPackage ePackage) {
        EEnum emfEnum = EcoreFactory.eINSTANCE.createEEnum();
        String enumName = this.createEnumName(tagName, attributeName, ENUM_SUFFIX);
        emfEnum.setName(enumName);
        emfEnum.setInstanceTypeName("java.lang.String");
        int i = 0;
        for (String value : data.getValues()) {
            EEnumLiteral emfEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
            emfEnumLiteral.setName(value);
            emfEnumLiteral.setLiteral(value);
            emfEnumLiteral.setValue(i++);
            emfEnum.getELiterals().add((Object)emfEnumLiteral);
        }
        ePackage.getEClassifiers().add((Object)emfEnum);
        return emfEnum;
    }

    protected String createEnumName(String tagName, String attributeName, String suffix) {
        StringBuilder builder = new StringBuilder();
        builder.append(tagName);
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        builder.append('_');
        int index = builder.length();
        builder.append(attributeName);
        builder.setCharAt(index, Character.toUpperCase(builder.charAt(index)));
        builder.append(suffix);
        return builder.toString();
    }

    protected boolean setDefaultValue(EAttribute emfAttribute, Entity attrMetadata) {
        Trait defaultValue = this.getTrait(attrMetadata, TraitId.DEFAULT_VALUE);
        if (defaultValue == null) {
            return false;
        }
        emfAttribute.setDefaultValue((Object)TraitValueHelper.getValueAsString((Trait)defaultValue));
        return true;
    }

    protected boolean setInitialValue(EAttribute emfAttribute, Entity attrMetadata) {
        Trait createValue = this.getTrait(attrMetadata, TraitId.INITIAL_VALUE);
        if (createValue == null) {
            return false;
        }
        EAnnotation anno = ECORE_FACTORY.createEAnnotation();
        anno.setSource("http://com.oracle/jsptagbase");
        anno.getDetails().put((Object)TraitId.INITIAL_VALUE.getId(), (Object)TraitValueHelper.getValueAsString((Trait)createValue));
        emfAttribute.getEAnnotations().add((Object)anno);
        return true;
    }

    protected boolean setRequired(EAttribute emfAttribute, Entity attrMetadata) {
        Trait required = this.getTrait(attrMetadata, TraitId.REQUIRED);
        if (required == null) {
            return false;
        }
        boolean isRequired = TraitValueHelper.getValueAsBoolean((Trait)required);
        if (!isRequired) {
            return false;
        }
        emfAttribute.setLowerBound(1);
        return true;
    }

    protected EDataType getEMFAttributeType(Trait attrType) {
        String attrTypeString = TraitValueHelper.getValueAsString((Trait)attrType);
        EDataType eDataType = TYPE_MAP.get(attrTypeString);
        return eDataType != null ? eDataType : XMLTypePackage.Literals.STRING;
    }

    private String createTagClassXMDName(String tagName) {
        StringBuilder builder = new StringBuilder(tagName);
        builder.append(TAG_CLASS_XMD_SUFFIX);
        return builder.toString();
    }

    private String createTagClassName(String tagName) {
        StringBuilder builder = new StringBuilder(tagName);
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        builder.append(TAG_CLASS_SUFFIX);
        return builder.toString();
    }

    private Entity getTagMetadata(IFile file, String tagLibUri, String tagName) {
        ITaglibDomainMetaDataQuery query = this.getTaglibMetaDataQuery(file);
        Model tagLibModel = query.findTagLibraryModel(tagLibUri);
        String simpleTagName = tagName;
        if (tagName.endsWith(TAG_CLASS_XMD_SUFFIX)) {
            simpleTagName = tagName.substring(0, tagName.lastIndexOf(TAG_CLASS_XMD_SUFFIX));
        }
        return query.findTagEntity(tagLibModel, simpleTagName);
    }

    private ITaglibDomainMetaDataQuery getTaglibMetaDataQuery(IFile file) {
        return (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(this.getMetaDataContext(file));
    }

    private IMetaDataDomainContext getMetaDataContext(IFile file) {
        if (this._metadataDomainContexts.get(file.getFullPath()) == null) {
            this._metadataDomainContexts.put(file.getFullPath(), MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file));
        }
        return this._metadataDomainContexts.get(file.getFullPath());
    }

    private Trait getTrait(Entity entity, TraitId traitId) {
        for (Trait trait : entity.getTraits()) {
            if (!trait.getId().equals(traitId.getId())) continue;
            return trait;
        }
        return null;
    }

    public static final class EnumerationData {
        private final List<String> _values;

        public EnumerationData(List<String> values) {
            this._values = Collections.unmodifiableList(new ArrayList<String>(values));
        }

        public List<String> getValues() {
            return this._values;
        }

        public int hashCode() {
            int code = 17;
            for (String value : this._values) {
                code = 37 * code + value.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EnumerationData)) {
                return false;
            }
            EnumerationData that = (EnumerationData)obj;
            List<String> otherValues = that.getValues();
            if (this._values.size() != otherValues.size()) {
                return false;
            }
            int i = 0;
            while (i < this._values.size()) {
                if (!this._values.get(i).equals(otherValues.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append('(');
            for (String value : this._values) {
                builder.append(value);
                builder.append(',');
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(')');
            return builder.toString();
        }
    }

    private static enum TraitId {
        ATTRIBUTE_VALUE_RUNTIME_TYPE("attribute-value-runtime-type"),
        VALID_VALUES("valid-values"),
        DEFAULT_VALUE("default-value"),
        INITIAL_VALUE("initial-value"),
        REQUIRED("required");

        private final String _id;

        private TraitId(String id) {
            this._id = id;
        }

        public String getId() {
            return this._id;
        }
    }
}

