/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.envcheck.wizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.eclipse.tools.envcheck.LaunchUtil;
import oracle.eclipse.tools.envcheck.LauncherPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;

public class SelectJavaVMWizardPage
extends WizardPage {
    private static final String JRE_REGISTRY_KEY = "HKEY_LOCAL_MACHINE\\Software\\JavaSoft\\Java Runtime Environment";
    private static final String JAVA_DOWNLOAD_URL = "http://www.java.com/en/download";
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("java version \"(.*)\".*");
    private boolean isJVMListCreated = false;
    private float fJvmVersion = 0.0f;
    private List validJREInstall = null;
    private Combo jvmLocationCombo = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected SelectJavaVMWizardPage(String pageName, float fJvmVersion) {
        super(pageName);
        this.fJvmVersion = fJvmVersion;
        this.setTitle(Resources.selectJVM);
        this.setMessage(Resources.selectJVMDesc);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!this.isJVMListCreated) {
            try {
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.setTaskName(Resources.detectingJvm);
                        SelectJavaVMWizardPage.this.validJREInstall = SelectJavaVMWizardPage.this.findJREInstallationsOnWindows("" + SelectJavaVMWizardPage.this.fJvmVersion, monitor);
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                int i = 0;
                                while (i < SelectJavaVMWizardPage.access$2(1.access$0(this.this$1)).size()) {
                                    File f = (File)SelectJavaVMWizardPage.access$2(1.access$0(this.this$1)).get(i);
                                    SelectJavaVMWizardPage.access$3(1.access$0(this.this$1)).add(f.getAbsolutePath());
                                    ++i;
                                }
                                if (SelectJavaVMWizardPage.access$2(1.access$0(this.this$1)).size() > 0) {
                                    SelectJavaVMWizardPage.access$3(1.access$0(this.this$1)).select(0);
                                }
                                SelectJavaVMWizardPage.access$4(1.access$0(this.this$1), true);
                            }
                        });
                    }

                    static /* synthetic */ SelectJavaVMWizardPage access$0(1 var0) {
                        return var0.SelectJavaVMWizardPage.this;
                    }
                };
                new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, operation);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    List findJREInstallationsOnWindows(String jreVersion, IProgressMonitor monitor) {
        ArrayList<File> ret = new ArrayList<File>();
        List lines = LaunchUtil.readWindowsRegistry(JRE_REGISTRY_KEY);
        monitor.beginTask(Resources.checkingJREs, lines.size());
        HashSet<String> uniqueJavaHomes = new HashSet<String>();
        int i = 0;
        while (i < lines.size()) {
            String version;
            String line = (String)lines.get(i);
            if (line.startsWith(JRE_REGISTRY_KEY) && line.length() > JRE_REGISTRY_KEY.length() && (version = line.substring(JRE_REGISTRY_KEY.length() + 1)).indexOf(jreVersion) >= 0) {
                monitor.worked(1);
                List jreSettings = LaunchUtil.readWindowsRegistry(line);
                Iterator it = jreSettings.iterator();
                while (it.hasNext()) {
                    int n;
                    String javaHome;
                    File f;
                    String s = (String)it.next();
                    if (s.indexOf("JavaHome") <= 0 || !(f = new File(javaHome = s.substring((n = s.lastIndexOf("REG_SZ")) + "REG_SZ".length() + 1).trim())).exists() || uniqueJavaHomes.contains(javaHome)) continue;
                    uniqueJavaHomes.add(javaHome);
                    ret.add(f);
                }
            }
            ++i;
        }
        return ret;
    }

    public void createControl(Composite parent) {
        Composite pageControl = new Composite(parent, 0);
        pageControl.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(pageControl, 0);
        label.setText(Resources.specifyJVM);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        this.jvmLocationCombo = new Combo(pageControl, 4);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.jvmLocationCombo.setLayoutData((Object)gd);
        this.jvmLocationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = SelectJavaVMWizardPage.this.jvmLocationCombo.getText();
                boolean isValid = SelectJavaVMWizardPage.this.verifyJvmVersion(path);
                SelectJavaVMWizardPage.this.setPageComplete(isValid);
            }
        });
        Button browseBtn = new Button(pageControl, 0);
        gd = new GridData();
        browseBtn.setText(Resources.browse);
        browseBtn.setLayoutData((Object)gd);
        browseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dlg.setFilterPath(SelectJavaVMWizardPage.this.jvmLocationCombo.getText());
                String path = dlg.open();
                if (path != null) {
                    boolean isValid = SelectJavaVMWizardPage.this.verifyJvmVersion(path);
                    SelectJavaVMWizardPage.this.jvmLocationCombo.setText(path);
                    SelectJavaVMWizardPage.this.setPageComplete(isValid);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Link downloadLink = new Link(pageControl, 0);
        downloadLink.setText(Resources.downloadJvm);
        downloadLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    URL url = new URL(SelectJavaVMWizardPage.JAVA_DOWNLOAD_URL);
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                }
                catch (Exception e) {
                    LauncherPlugin.log(e);
                }
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        downloadLink.setLayoutData((Object)gd);
        this.setControl((Control)pageControl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readFully(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                buf.append(line);
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            in.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        in.close();
        return buf.toString();
    }

    private boolean verifyJvmVersion(String path) {
        String versionString;
        block12: {
            block14: {
                boolean isEclipseJvm64bit;
                block13: {
                    Matcher javaVersionPatternMatcher;
                    File javaBinFolder;
                    block11: {
                        versionString = null;
                        try {
                            javaBinFolder = new File(path, "bin");
                            if (javaBinFolder.exists() && javaBinFolder.isDirectory()) break block11;
                            this.setErrorMessage(Resources.invalidJavaHome);
                            return false;
                        }
                        catch (Exception exception) {}
                    }
                    Process process = Runtime.getRuntime().exec(new String[]{javaBinFolder + "/" + "java", "-version"}, null, javaBinFolder);
                    String javaVersionOutput = SelectJavaVMWizardPage.readFully(process.getInputStream());
                    if (javaVersionOutput.length() == 0) {
                        javaVersionOutput = SelectJavaVMWizardPage.readFully(process.getErrorStream());
                    }
                    if ((javaVersionPatternMatcher = JAVA_VERSION_PATTERN.matcher(javaVersionOutput)).find()) {
                        versionString = javaVersionPatternMatcher.group(1);
                    }
                    if (versionString == null || !versionString.startsWith("1.7.") && !versionString.startsWith("1.8.")) break block12;
                    String vmArch = System.getProperty("osgi.arch");
                    isEclipseJvm64bit = !"x86".equalsIgnoreCase(vmArch);
                    boolean isSelectedJvm64bit = false;
                    if (javaVersionOutput.toLowerCase().indexOf("64-bit") != -1) {
                        isSelectedJvm64bit = true;
                    }
                    if (!isSelectedJvm64bit) break block13;
                    if (!isEclipseJvm64bit) {
                        this.setErrorMessage(Resources.require32bitJava);
                        return false;
                    }
                    break block14;
                }
                if (!isEclipseJvm64bit) break block14;
                this.setErrorMessage(Resources.require64bitJava);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
        if (versionString == null) {
            this.setErrorMessage(Resources.invalidJavaHome);
        } else {
            this.setErrorMessage(NLS.bind((String)Resources.invalidJavaVersion, versionString));
        }
        return false;
    }

    public File getVmLocation() {
        return new File(this.jvmLocationCombo.getText(), "bin");
    }

    static /* synthetic */ List access$2(SelectJavaVMWizardPage selectJavaVMWizardPage) {
        return selectJavaVMWizardPage.validJREInstall;
    }

    static /* synthetic */ void access$4(SelectJavaVMWizardPage selectJavaVMWizardPage, boolean bl) {
        selectJavaVMWizardPage.isJVMListCreated = bl;
    }

    public static final class Resources
    extends NLS {
        public static String require64bitJava;
        public static String require32bitJava;
        public static String selectJVM;
        public static String selectJVMDesc;
        public static String specifyJVM;
        public static String detectingJvm;
        public static String downloadJvm;
        public static String checkingJREs;
        public static String browse;
        public static String invalidJavaHome;
        public static String invalidJavaVersion;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("oracle.eclipse.tools.envcheck.wizard.SelectJavaVMWizardPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("oracle.eclipse.tools.envcheck.wizard.SelectJavaVMWizardPage$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }
    }
}

