/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.envcheck;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class LaunchUtil {
    public static final String JRE_QUERY_CMD = "reg query \"";

    public static Float getEclipseVMVersion() {
        String javaVer = System.getProperty("java.version", "");
        if (javaVer.length() > 2) {
            String version = javaVer.substring(0, 3);
            try {
                Float f = Float.valueOf(version);
                return f;
            }
            catch (Exception exception) {}
        }
        return new Float("1.5");
    }

    public static boolean checkEclipseVMVersion(float minVMVersion) {
        Float f = LaunchUtil.getEclipseVMVersion();
        return f.floatValue() >= minVMVersion;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void modifyEclipseLaunchArg(String key, String newValue, boolean replace) {
        String launcherName = System.getProperty("eclipse.launcher");
        File launcher = new File(launcherName);
        if (!launcher.exists()) return;
        File iniFile = new File(launcher.getParentFile(), "eclipse.ini");
        StringBuffer buf = new StringBuffer();
        if (!iniFile.exists()) return;
        String separator = System.getProperty("line.separator");
        try {
            BufferedReader br;
            block15: {
                String newKeyValue;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(iniFile), "UTF-8"));
                String line = br.readLine();
                boolean foundKey = false;
                while (true) {
                    if (line == null) {
                        if (!foundKey) {
                            newKeyValue = String.valueOf(key) + separator + newValue + separator;
                            if (!key.equals("-vm")) break;
                            buf.insert(0, newKeyValue);
                        }
                        break block15;
                    }
                    buf.append(line);
                    buf.append(separator);
                    if (line.equals(key)) {
                        foundKey = true;
                        if (!replace) {
                            buf.append(newValue);
                            buf.append(separator);
                        } else {
                            buf.append(newValue);
                            buf.append(separator);
                            br.readLine();
                        }
                    }
                    line = br.readLine();
                }
                buf.append(newKeyValue);
            }
            br.close();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(iniFile), "UTF-8");
            try {
                w.write(buf.toString());
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    ((Writer)w).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var12_16 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                ((Writer)w).close();
                return;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List readWindowsRegistry(String regKey) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(JRE_QUERY_CMD + regKey + "\"");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            while (line != null) {
                ret.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception exception) {}
        return ret;
    }
}

