/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.internal;

import java.io.IOException;
import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.WlstFacetInstallDelegate;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsScriptingPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class WlstProjectImportUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    public boolean check(IProject project) throws CoreException {
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return false;
        }
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        if (facetedProject != null) {
            for (IProjectFacetVersion fv : facetedProject.getProjectFacets()) {
                if (!fv.getProjectFacet().getId().equals(WlsScriptingPlugin.FACET_WLST.getId())) continue;
                try {
                    if (WlstFacetInstallDelegate.isWlstInterpreterCreated((IProgressMonitor)new NullProgressMonitor(), facetedProject.getPrimaryRuntime())) continue;
                    return true;
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) throws CoreException {
        IFile f = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {}
        IRuntime frt = facetedProject.getPrimaryRuntime();
        org.eclipse.wst.server.core.IRuntime rt = RuntimeBridgeUtil.bridge((IRuntime)frt);
        try {
            WlstFacetInstallDelegate.createWlstInterpreter(monitor, rt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

