/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.facets.internal;

import java.util.HashMap;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.WlstFacetInstallDelegate;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsScriptingPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.plugin.nature.PythonNature;

public class WlstFacetVersionChangeDelegate
extends WlstFacetInstallDelegate {
    @Override
    public void execute(final IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"WLST Facet Migartion", (int)3);
        try {
            IPythonPathNature nature = PythonNature.getPythonPathNature((IProject)project);
            if (nature == null) {
                return;
            }
            final String projectPythonpath = PythonNature.getPythonPathNature((IProject)project).getProjectSourcePath(true);
            PythonNature.removeNature((IProject)project, (IProgressMonitor)monitor);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            final IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            IFacetedProjectListener listener = new IFacetedProjectListener(){

                public void handleEvent(IFacetedProjectEvent event) {
                    fproj.removeListener((IFacetedProjectListener)this);
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    IRuntimeComponent rtComp = WlsRuntimeUtil.getWlsRuntimeComponent((IProject)project);
                    try {
                        if (rtComp == null || rtComp.getRuntime() == null) {
                            throw new CoreException(WlsScriptingPlugin.createErrorStatus("Project must target to WebLogic runtime"));
                        }
                        String wlstInterpreterName = WlstFacetVersionChangeDelegate.createWlstInterpreter((IProgressMonitor)monitor, RuntimeBridgeUtil.bridge((IRuntime)rtComp.getRuntime()));
                        ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                        String externalProjectPythonpath = "";
                        HashMap variableSubstitution = new HashMap();
                        String projectInterpreter = wlstInterpreterName;
                        String projectType = "jython 2.1";
                        PythonNature.addNature((IProject)project, (IProgressMonitor)monitor, (String)projectType, (String)projectPythonpath, (String)externalProjectPythonpath, (String)projectInterpreter, variableSubstitution);
                    }
                    catch (Exception e) {
                        WlsScriptingPlugin.getDefault().getLog().log(WlsScriptingPlugin.createErrorStatus(e));
                    }
                }
            };
            fproj.addListener(listener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED});
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }
}

