/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.facets.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.common.util.fileio.FileUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.Messages;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.WlstFacetInstallConfig;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsRuntimeLifecycleListener;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsScriptingPlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.util.internal.ZipUtil;
import org.eclipse.wst.server.core.IRuntime;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class WlstFacetInstallDelegate
implements IDelegate {
    protected static final String JYTHON_VERSION = "jython 2.1";
    protected static final String WLST_INTERPRETER_NAME = "WebLogic %s WLST Interpreter";
    private static WlsRuntimeLifecycleListener wlsRuntimeLifecycleListener = null;

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)4);
        try {
            try {
                WlstFacetInstallConfig config = (WlstFacetInstallConfig)((Object)cfg);
                this.createWlstSourceFolders(project, config);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = WlsRuntimeUtil.getWlsRuntimeComponent((IProject)project).getRuntime();
                String wlstInterpreterName = WlstFacetInstallDelegate.createWlstInterpreter(monitor, RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt));
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
                this.addPydevNature(project, monitor, config, wlstInterpreterName);
                ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            }
            catch (IOException e) {
                WlsScriptingPlugin.getDefault().getLog().log(WlsScriptingPlugin.createErrorStatus(e));
                ProgressMonitorUtil.done((IProgressMonitor)monitor);
            }
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    public static synchronized boolean isWlstInterpreterCreated(IProgressMonitor monitor, org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt) throws CoreException, IOException {
        IRuntime rt = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
        File wlsPath = WlsRuntimeUtil.getWlsRuntimePath((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
        if (wlsPath == null || !wlsPath.exists()) {
            throw new CoreException(WlsScriptingPlugin.createErrorStatus(Messages.wlstRequiresWlsRT));
        }
        String wlsRtPath = wlsPath.getAbsolutePath();
        String wlsRtVersion = rt.getRuntimeType().getVersion();
        String wlstInterpreterJarPath = String.valueOf(wlsRtPath) + WlstFacetInstallDelegate.getJythonJarPath(wlsRtVersion);
        IInterpreterManager jythonInterpreterManager = PydevPlugin.getJythonInterpreterManager();
        String s = jythonInterpreterManager.getPersistedString();
        IInterpreterInfo[] executables = jythonInterpreterManager.getInterpretersFromPersistedString(s);
        ArrayList<IInterpreterInfo> existingInterpreters = new ArrayList<IInterpreterInfo>();
        boolean wlstExisting = false;
        int i = 0;
        while (i < executables.length) {
            IInterpreterInfo interpreterInfo = executables[i];
            existingInterpreters.add(interpreterInfo);
            if (interpreterInfo.getExecutableOrJar().equals(wlstInterpreterJarPath)) {
                wlstExisting = true;
                break;
            }
            ++i;
        }
        return wlstExisting;
    }

    public static synchronized String createWlstInterpreter(IProgressMonitor monitor, IRuntime rt) throws CoreException, IOException {
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime frt = RuntimeBridgeUtil.bridge((IRuntime)rt);
        WlstFacetInstallDelegate.setJythonCacheDir();
        InterpreterInfo info = null;
        File wlsPath = WlsRuntimeUtil.getWlsRuntimePath((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)frt);
        if (wlsPath == null || !wlsPath.exists()) {
            throw new CoreException(WlsScriptingPlugin.createErrorStatus(Messages.wlstRequiresWlsRT));
        }
        String wlsRtPath = wlsPath.getAbsolutePath();
        String wlsRtVersion = rt.getRuntimeType().getVersion();
        String wlstInterpreterName = String.format(WLST_INTERPRETER_NAME, wlsRtVersion);
        String wlstInterpreterJarPath = String.valueOf(wlsRtPath) + WlstFacetInstallDelegate.getJythonJarPath(wlsRtVersion);
        IInterpreterManager jythonInterpreterManager = PydevPlugin.getJythonInterpreterManager();
        String s = jythonInterpreterManager.getPersistedString();
        IInterpreterInfo[] executables = jythonInterpreterManager.getInterpretersFromPersistedString(s);
        ArrayList<Object> existingInterpreters = new ArrayList<Object>();
        boolean wlstExisting = false;
        int i = 0;
        while (i < executables.length) {
            IInterpreterInfo interpreterInfo = executables[i];
            existingInterpreters.add(interpreterInfo);
            if (interpreterInfo.getExecutableOrJar().equals(wlstInterpreterJarPath)) {
                info = (InterpreterInfo)interpreterInfo;
                wlstExisting = true;
                break;
            }
            ++i;
        }
        File jythonLibDir = new File(String.valueOf(wlsRtPath) + "/common/wlst/modules/jython-modules/Lib");
        if (!jythonLibDir.exists()) {
            File jythonModuleJar = new File(String.valueOf(wlsRtPath) + "/common/wlst/modules/jython-modules.jar");
            try {
                jythonLibDir.mkdirs();
                ZipUtil.unzip((File)jythonModuleJar, (File)jythonLibDir.getParentFile());
            }
            catch (IOException e) {
                String msg = "Failed to expand " + jythonModuleJar.getAbsolutePath();
                msg = String.valueOf(msg) + ".\n WLST code completion will not work this. Please check your file system permission";
                WlsScriptingPlugin.getDefault().getLog().log(WlsScriptingPlugin.createErrorStatus(msg, e));
            }
        }
        if (!wlstExisting) {
            ArrayList<String> wlsJythonLibs = new ArrayList<String>();
            if (wlsRtVersion.equals("9.2") || wlsRtVersion.equals("10.0")) {
                wlsJythonLibs.add(String.valueOf(wlsRtPath) + "/server/lib/weblogic.jar");
            }
            wlsJythonLibs.add(String.valueOf(wlsRtPath) + "/common/wlst/");
            wlsJythonLibs.add(String.valueOf(wlsRtPath) + "/common/wlst/modules");
            wlsJythonLibs.add(String.valueOf(wlsRtPath) + "/common/wlst/lib/");
            wlsJythonLibs.add(String.valueOf(wlsRtPath) + "/common/wlst/modules/jython-modules/Lib");
            File mwHome = WlsRuntimeUtil.getMwHome((File)rt.getLocation().toFile());
            File oracleCommon = new File(mwHome, "oracle_common");
            if (oracleCommon.exists()) {
                File setWlstEnvCmd;
                File res;
                int n;
                String oracleCommonPath = oracleCommon.getAbsolutePath().replace('\\', '/');
                wlsJythonLibs.add(String.valueOf(oracleCommonPath) + "/common/wlst/");
                wlsJythonLibs.add(String.valueOf(oracleCommonPath) + "/common/wlst/lib/");
                wlsJythonLibs.add(String.valueOf(oracleCommonPath) + "/common/wlst/resources");
                File libs = new File(String.valueOf(oracleCommonPath) + "/common/wlst/lib/");
                if (libs.exists()) {
                    File[] fileArray = libs.listFiles();
                    n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getName().endsWith(".jar")) {
                            wlsJythonLibs.add(f.getAbsolutePath().replace('\\', '/'));
                        }
                        ++n2;
                    }
                }
                if ((res = new File(String.valueOf(oracleCommonPath) + "/common/wlst/resources")).exists()) {
                    File[] fileArray = res.listFiles();
                    int n3 = fileArray.length;
                    n = 0;
                    while (n < n3) {
                        File f = fileArray[n];
                        if (f.getName().endsWith(".jar")) {
                            wlsJythonLibs.add(f.getAbsolutePath().replace('\\', '/'));
                        }
                        ++n;
                    }
                }
                if ((setWlstEnvCmd = new File(String.valueOf(oracleCommonPath) + "/common/bin/setWlstEnv.cmd")).exists()) {
                    try {
                        String content = FileUtil.readTextFile((File)setWlstEnvCmd);
                        content = content.substring("SET CLASSPATH=%CLASSPATH%;".length());
                        String[] stringArray = content.split(";");
                        int n4 = stringArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String str = stringArray[n5];
                            String jarName = str.replace("%COMMON_COMPONENTS_HOME%", oracleCommonPath);
                            wlsJythonLibs.add(jarName);
                            ++n5;
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            monitor.setTaskName(Messages.WlstFacetInstallDelegate_11);
            monitor.beginTask(Messages.WlstFacetInstallDelegate_12, -1);
            info = new InterpreterInfo(WlstFacetInstallDelegate.getJythonVersion(wlsRtVersion), wlstInterpreterJarPath, wlsJythonLibs);
            info.setName(wlstInterpreterName);
            info.addForcedLib("wlstModule");
            org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = frt;
            IRuntime r = RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            IWeblogicServerRuntime wsr = (IWeblogicServerRuntime)r.getAdapter(IWeblogicServerRuntime.class);
            IPath javaVMLocation = wsr.getJavaVmLocation();
            ArrayList<File> jars = new ArrayList<File>();
            jars.add(new File(String.valueOf(javaVMLocation.toPortableString()) + Messages.WlstFacetInstallDelegate_13));
            for (File jar : jars) {
                info.libs.add(WlstFacetInstallDelegate.getFileAbsolutePath(jar));
            }
            info.restoreCompiledLibs(monitor);
            String[] env = new String[]{"python.cachedir.skip=true"};
            info.setEnvVariables(env);
            existingInterpreters.add(info);
            HashSet names = new HashSet();
            InterpreterInfo[] interpreterInfo = new InterpreterInfo[existingInterpreters.size()];
            interpreterInfo = existingInterpreters.toArray(interpreterInfo);
            jythonInterpreterManager.setInfos((IInterpreterInfo[])interpreterInfo, names, monitor);
        }
        jythonInterpreterManager.clearCaches();
        if (wlsRuntimeLifecycleListener == null) {
            wlsRuntimeLifecycleListener = new WlsRuntimeLifecycleListener();
            WlsRuntimeSpy.addListener((WlsRuntimeSpy.IListener)wlsRuntimeLifecycleListener, (WlsRuntimeSpy.EventType[])new WlsRuntimeSpy.EventType[]{WlsRuntimeSpy.EventType.ADDED, WlsRuntimeSpy.EventType.CHANGED});
        }
        return wlstInterpreterName;
    }

    public static String getFileAbsolutePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException iOException) {
            return f.getAbsolutePath();
        }
    }

    private void createWlstSourceFolders(IProject project, WlstFacetInstallConfig config) {
        for (IPath srcPath : config.getSourceFolders()) {
            IFolder folder = project.getFolder(srcPath);
            if (folder.exists()) continue;
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e1) {
                WlsScriptingPlugin.getDefault().getLog().log(WlsScriptingPlugin.createErrorStatus((Exception)((Object)e1)));
            }
        }
    }

    private static void setJythonCacheDir() throws IOException {
        String cacheDir = PydevPrefs.getChainedPrefStore().getString("JYTHON_CACHE_DIR");
        if (cacheDir == null || !new File(cacheDir).exists()) {
            String tempPath = System.getProperty("java.io.tmpdir");
            File jythonCache = new File(tempPath, "jython_cache").getCanonicalFile();
            jythonCache.mkdirs();
            PydevPrefs.getPreferences().setValue("JYTHON_CACHE_DIR", jythonCache.getAbsolutePath());
        }
    }

    private void addPydevNature(IProject project, IProgressMonitor monitor, WlstFacetInstallConfig config, String wlstInterpreterName) {
        monitor.beginTask(Messages.WlstFacetInstallDelegate_15, -1);
        String PYDEV_INTERPRETER_KEY = "INTERPRETER_CONFIGURATION_0";
        String DONT_ASK_AGAIN_PREFERENCE_VALUE = "DONT_ASK";
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(PYDEV_INTERPRETER_KEY);
        if (!val.equals(DONT_ASK_AGAIN_PREFERENCE_VALUE)) {
            store.putValue(PYDEV_INTERPRETER_KEY, DONT_ASK_AGAIN_PREFERENCE_VALUE);
        }
        try {
            String projectType = JYTHON_VERSION;
            StringBuilder projectPythonpath = new StringBuilder();
            Iterator<IPath> it = config.getSourceFolders().iterator();
            while (it.hasNext()) {
                IPath path = it.next();
                projectPythonpath.append("/" + project.getName() + "/" + path.toPortableString());
                if (!it.hasNext()) continue;
                projectPythonpath.append('|');
            }
            try {
                IJavaProject jproj = JavaCore.create((IProject)project);
                if (jproj != null) {
                    projectPythonpath.append('|');
                    String javaOutput = jproj.getOutputLocation().toFile().getAbsolutePath();
                    projectPythonpath.append(javaOutput);
                }
            }
            catch (Exception exception) {}
            String externalProjectPythonpath = "";
            HashMap variableSubstitution = new HashMap();
            String projectInterpreter = wlstInterpreterName;
            PythonNature.addNature((IProject)project, (IProgressMonitor)monitor, (String)projectType, (String)projectPythonpath.toString(), (String)externalProjectPythonpath, (String)projectInterpreter, variableSubstitution);
        }
        catch (CoreException e) {
            WlsScriptingPlugin.getDefault().getLog().log(WlsScriptingPlugin.createErrorStatus((Exception)((Object)e)));
        }
    }

    protected static String getJythonVersion(String wlsRtVersion) {
        if (wlsRtVersion.equals("9.2") || wlsRtVersion.equals("10.0")) {
            return "2.1";
        }
        return "2.2.1";
    }

    protected static String getJythonJarPath(String wlsRtVersion) {
        if (wlsRtVersion.equals("9.2") || wlsRtVersion.equals("10.0")) {
            return "/common/lib/jython.jar";
        }
        return "/server/lib/weblogic.jar";
    }
}

