/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.scripting.facets.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.eclipse.tools.weblogic.scripting.facets.internal.Messages;
import oracle.eclipse.tools.weblogic.scripting.internal.WlsScriptingPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.project.facet.core.ActionConfig;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.util.EventListenerRegistry;
import org.eclipse.wst.common.project.facet.core.util.IEventListener;

public class WlstFacetInstallConfig
extends ActionConfig {
    public static final String WLST_SRC_PATH = "wlst";
    private EventListenerRegistry<ChangeEvent.Type, ChangeEvent> listeners = new EventListenerRegistry(ChangeEvent.Type.class);
    private List<IPath> sourceFolders = new CopyOnWriteArrayList<IPath>();
    private List<IPath> sourceFoldersReadOnly = Collections.unmodifiableList(this.sourceFolders);

    public WlstFacetInstallConfig() {
        this.sourceFolders.add((IPath)new Path(WLST_SRC_PATH));
    }

    public void setFacetedProjectWorkingCopy(IFacetedProjectWorkingCopy fpjwc) {
        super.setFacetedProjectWorkingCopy(fpjwc);
    }

    public Set<IFile> getValidateEditFiles() {
        Set files = super.getValidateEditFiles();
        IProject project = this.getFacetedProjectWorkingCopy().getProject();
        if (project != null) {
            files.add(project.getFile(".project"));
        }
        return files;
    }

    public List<IPath> getSourceFolders() {
        return this.sourceFoldersReadOnly;
    }

    public void setSourceFolders(List<IPath> paths) {
        if (!this.sourceFolders.equals(paths)) {
            this.sourceFolders.clear();
            this.sourceFolders.addAll(paths);
            ChangeEvent event = new ChangeEvent(ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, this);
            this.listeners.notifyListeners((Enum)ChangeEvent.Type.SOURCE_FOLDERS_CHANGED, (Object)event);
        }
    }

    public void setSourceFolder(IPath path) {
        List<Object> newSourceFolders = path == null ? Collections.emptyList() : Collections.singletonList(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void addSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.add(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void removeSourceFolder(IPath path) {
        ArrayList<IPath> newSourceFolders = new ArrayList<IPath>(this.getSourceFolders());
        newSourceFolders.remove(path);
        this.setSourceFolders(newSourceFolders);
    }

    public void addListener(IEventListener<ChangeEvent> iEventListener, ChangeEvent.Type sourceFoldersChanged) {
        this.listeners.addListener(iEventListener, (Enum[])new ChangeEvent.Type[]{sourceFoldersChanged});
    }

    public void removeListener(IEventListener<ChangeEvent> listener) {
        this.listeners.removeListener(listener);
    }

    public IStatus validate() {
        if (this.getFacetedProjectWorkingCopy().getTargetedRuntimes().size() == 0) {
            return WlsScriptingPlugin.createErrorStatus(Messages.wlstRequiresWlsRT);
        }
        for (IRuntime rt : this.getFacetedProjectWorkingCopy().getTargetedRuntimes()) {
            if (rt.supports(this.getProjectFacetVersion())) continue;
            return WlsScriptingPlugin.createErrorStatus(Messages.wlstRequiresWlsRT);
        }
        if (this.getSourceFolders().size() == 0) {
            return WlsScriptingPlugin.createErrorStatus(Messages.wlstSourceFolder);
        }
        return super.validate();
    }

    public static class ChangeEvent {
        private final Type type;
        private final WlstFacetInstallConfig installConfig;

        ChangeEvent(Type type, WlstFacetInstallConfig installConfig) {
            this.type = type;
            this.installConfig = installConfig;
        }

        public final Type getType() {
            return this.type;
        }

        public final WlstFacetInstallConfig getJavaFacetInstallConfig() {
            return this.installConfig;
        }

        public static enum Type {
            SOURCE_FOLDERS_CHANGED;

        }
    }
}

