/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorTreeItemContentProviderFactory
implements ItemTreeContentProvider.Factory {
    private HashMap<JaxbPlatformConfig, ItemTreeContentProvider.Factory> delegates = new HashMap();

    public ItemTreeContentProvider buildProvider(Object item, ItemTreeContentProvider.Manager manager) {
        ItemTreeContentProvider.Factory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildProvider(item, manager);
        }
        return null;
    }

    private ItemTreeContentProvider.Factory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JaxbContextNode contextNode = (JaxbContextNode)((IAdaptable)element).getAdapter(JaxbContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JaxbPlatform jaxbPlatform = contextNode.getJaxbProject().getPlatform();
        JaxbPlatformConfig jaxbPlatformConfig = jaxbPlatform.getConfig();
        if (this.delegates.containsKey(jaxbPlatformConfig)) {
            return this.delegates.get(jaxbPlatformConfig);
        }
        JaxbPlatformUi platformUi = (JaxbPlatformUi)jaxbPlatform.getAdapter(JaxbPlatformUi.class);
        ItemTreeContentProvider.Factory delegate = platformUi == null ? null : platformUi.getNavigatorUi().getTreeItemContentProviderFactory();
        this.delegates.put(jaxbPlatformConfig, delegate);
        return delegate;
    }
}

