/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.core.internal.utility.PlatformTools;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.jface.NavigatorContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.ui.JaxbWorkbench;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorItemLabelProviderFactory;
import org.eclipse.jpt.jaxb.ui.internal.navigator.JaxbNavigatorTreeItemContentProviderFactory;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorContentProvider
extends NavigatorContentProvider {
    private final JaxbProjectManager jaxbProjectManager;
    private final CollectionChangeListener jaxbProjectListener = this.buildJaxbProjectListener();
    private StructuredViewer viewer;

    public JaxbNavigatorContentProvider() {
        this.jaxbProjectManager = this.getJaxbProjectManager();
        if (this.jaxbProjectManager != null) {
            this.jaxbProjectManager.addCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
        }
    }

    protected CollectionChangeListener buildJaxbProjectListener() {
        return new JaxbProjectListener();
    }

    protected ItemTreeContentProvider.Factory buildItemContentProviderFactory() {
        return new JaxbNavigatorTreeItemContentProviderFactory();
    }

    protected ItemExtendedLabelProvider.Factory buildItemLabelProviderFactory() {
        return new JaxbNavigatorItemLabelProviderFactory();
    }

    protected ResourceManager buildResourceManager() {
        return new LocalResourceManager(this.getParentResourceManager());
    }

    protected ResourceManager getParentResourceManager() {
        return JFaceResources.getResources();
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        super.inputChanged(v, oldInput, newInput);
        this.viewer = (StructuredViewer)v;
    }

    protected boolean hasChildren_(Object element) {
        JaxbProject jaxbProject;
        IProject project;
        if (element instanceof IAdaptable && (project = (IProject)((IAdaptable)element).getAdapter(IProject.class)) != null && (jaxbProject = this.getJaxbProject(project)) != null) {
            JaxbPlatformUi platformUi = (JaxbPlatformUi)jaxbProject.getPlatform().getAdapter(JaxbPlatformUi.class);
            return platformUi != null;
        }
        return false;
    }

    protected JaxbProject getJaxbProject(IProject project) {
        return this.jaxbProjectManager == null ? null : this.jaxbProjectManager.getJaxbProject(project);
    }

    protected Object[] getChildren_(Object parentElement) {
        JaxbPlatformUi platformUi;
        JaxbProject jaxbProject;
        IProject project;
        if (parentElement instanceof IAdaptable && (project = (IProject)((IAdaptable)parentElement).getAdapter(IProject.class)) != null && (jaxbProject = this.getJaxbProject(project)) != null && (platformUi = (JaxbPlatformUi)jaxbProject.getPlatform().getAdapter(JaxbPlatformUi.class)) != null) {
            return new Object[]{jaxbProject.getContextRoot()};
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.jaxbProjectManager != null) {
            this.jaxbProjectManager.removeCollectionChangeListener("jaxbProjects", this.jaxbProjectListener);
        }
    }

    private JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        JaxbWorkbench jaxbWorkbench = this.getJaxbWorkbench();
        return jaxbWorkbench == null ? null : jaxbWorkbench.getJaxbWorkspace();
    }

    private JaxbWorkbench getJaxbWorkbench() {
        return (JaxbWorkbench)PlatformTools.getAdapter((Object)WorkbenchTools.getWorkbench(), JaxbWorkbench.class);
    }

    class JaxbProjectListener
    implements CollectionChangeListener {
        JaxbProjectListener() {
        }

        public void collectionChanged(CollectionChangeEvent event) {
            this.refreshViewer(null);
        }

        public void collectionCleared(CollectionClearEvent event) {
            this.refreshViewer(null);
        }

        public void itemsAdded(CollectionAddEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        public void itemsRemoved(CollectionRemoveEvent event) {
            for (Object item : event.getItems()) {
                this.refreshViewer(((JaxbProject)item).getProject());
            }
        }

        private void refreshViewer(final IProject project) {
            if (JaxbNavigatorContentProvider.this.viewer != null && JaxbNavigatorContentProvider.this.viewer.getControl() != null && !JaxbNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                Job refreshJob = new Job("Refresh viewer"){

                    protected IStatus run(IProgressMonitor monitor) {
                        JaxbNavigatorContentProvider.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (project != null) {
                                    JaxbNavigatorContentProvider.this.viewer.refresh((Object)project);
                                } else {
                                    JaxbNavigatorContentProvider.this.viewer.refresh();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.setRule((ISchedulingRule)project);
                refreshJob.schedule();
            }
        }
    }
}

