/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.jaxb21;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.model.value.AspectPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiImages;
import org.eclipse.jpt.jaxb.ui.internal.jaxb21.JavaTypeItemLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassItemLabelProvider
extends JavaTypeItemLabelProvider<JavaClass> {
    public JavaClassItemLabelProvider(JavaClass jaxbClass, ItemExtendedLabelProvider.Manager manager) {
        super(jaxbClass, manager);
    }

    protected PropertyValueModel<ImageDescriptor> buildImageDescriptorModel() {
        return new JavaClassImageDescriptorModel((JavaClass)this.item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JavaClassImageDescriptorModel
    extends AspectPropertyValueModelAdapter<JavaClass, ImageDescriptor> {
        protected final PropertyValueModel<Boolean> isXmlRegistryModel;
        protected final PropertyValueModel<JavaClassMapping> mappingModel;
        protected final PropertyValueModel<Boolean> isXmlTransientModel;
        protected final PropertyChangeListener propertyChangeListener;

        public JavaClassImageDescriptorModel(JavaClass subject) {
            super((PropertyValueModel)new StaticPropertyValueModel((Object)subject));
            this.isXmlRegistryModel = this.buildIsXmlRegistryModel();
            this.mappingModel = this.buildMappingModel();
            this.isXmlTransientModel = this.buildIsXmlTransientModel();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        protected PropertyValueModel<Boolean> buildIsXmlRegistryModel() {
            return new PropertyAspectAdapter<JavaClass, Boolean>("xmlRegistry", (JavaClass)JavaClassItemLabelProvider.this.item){

                protected Boolean buildValue_() {
                    return ((JavaClass)this.subject).getXmlRegistry() != null;
                }
            };
        }

        protected PropertyValueModel<JavaClassMapping> buildMappingModel() {
            return new PropertyAspectAdapter<JavaClass, JavaClassMapping>("mapping", (JavaClass)JavaClassItemLabelProvider.this.item){

                protected JavaClassMapping buildValue_() {
                    return ((JavaClass)this.subject).getMapping();
                }
            };
        }

        protected PropertyValueModel<Boolean> buildIsXmlTransientModel() {
            return new PropertyAspectAdapter<JavaClassMapping, Boolean>(this.mappingModel, new String[]{"xmlTransient"}){

                protected Boolean buildValue_() {
                    return ((JavaClassMapping)this.subject).isXmlTransient();
                }
            };
        }

        protected PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    JavaClassImageDescriptorModel.this.aspectChanged();
                }
            };
        }

        protected ImageDescriptor buildValue_() {
            if (this.mappingModel.getValue() != null && this.isXmlTransientModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiImages.JAXB_TRANSIENT_CLASS;
            }
            if (this.isXmlRegistryModel.getValue() == Boolean.TRUE) {
                return JptJaxbUiImages.JAXB_REGISTRY;
            }
            return JptJaxbUiImages.JAXB_CLASS;
        }

        protected void engageSubject_() {
            this.isXmlRegistryModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.addPropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.addPropertyChangeListener("value", this.propertyChangeListener);
        }

        protected void disengageSubject_() {
            this.isXmlRegistryModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.mappingModel.removePropertyChangeListener("value", this.propertyChangeListener);
            this.isXmlTransientModel.removePropertyChangeListener("value", this.propertyChangeListener);
        }
    }
}

