/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.editing.LifecycleMappingOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.lifecycle.AbstractLifecycleMappingProposal;
import org.eclipse.m2e.editor.xml.internal.lifecycle.LifecycleMappingDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleMappingProposal
extends AbstractLifecycleMappingProposal
implements ICompletionProposal,
ICompletionProposalExtension5 {
    private static final Logger log = LoggerFactory.getLogger(LifecycleMappingProposal.class);
    private IQuickAssistInvocationContext context;

    public LifecycleMappingProposal(IQuickAssistInvocationContext context, MarkerAnnotation mark, PluginExecutionAction action) {
        super(mark.getMarker(), action);
        this.context = context;
    }

    public LifecycleMappingProposal(IMarker marker, PluginExecutionAction action) {
        super(marker, action);
    }

    public void apply(IDocument doc) {
        try {
            if (PluginExecutionAction.ignore.equals((Object)this.action)) {
                this.performIgnore(new IMarker[]{this.marker});
            } else {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(doc, (PomEdits.Operation)this.createOperation(this.marker))});
            }
        }
        catch (IOException e) {
            log.error("Error generating code in pom.xml", (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void performIgnore(IMarker[] marks) throws IOException, CoreException {
        final IFile[] pomFile = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LifecycleMappingDialog dialog = new LifecycleMappingDialog(Display.getCurrent().getActiveShell(), (IFile)LifecycleMappingProposal.this.marker.getResource(), LifecycleMappingProposal.this.marker.getAttribute("groupId", ""), LifecycleMappingProposal.this.marker.getAttribute("artifactId", ""), LifecycleMappingProposal.this.marker.getAttribute("version", ""), LifecycleMappingProposal.this.marker.getAttribute("goal", ""));
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    pomFile[0] = dialog.getPomFile();
                }
            }
        });
        if (pomFile[0] != null) {
            ArrayList<LifecycleMappingOperation> lst = new ArrayList<LifecycleMappingOperation>();
            IMarker[] iMarkerArray = marks;
            int n = marks.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                lst.add(this.createOperation(m));
                ++n2;
            }
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(pomFile[0], (PomEdits.Operation)new PomEdits.CompoundOperation(lst.toArray(new PomEdits.Operation[0])))});
        }
    }

    private LifecycleMappingOperation createOperation(IMarker mark) {
        String pluginGroupId = mark.getAttribute("groupId", "");
        String pluginArtifactId = mark.getAttribute("artifactId", "");
        String pluginVersion = mark.getAttribute("version", "");
        String[] goals = new String[]{mark.getAttribute("goal", "")};
        return new LifecycleMappingOperation(pluginGroupId, pluginArtifactId, pluginVersion, this.action, goals);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public String getDisplayString() {
        String goal = this.marker.getAttribute("goal", "");
        return PluginExecutionAction.ignore.equals((Object)this.action) ? NLS.bind((String)Messages.LifecycleMappingProposal_ignore_label, (Object)goal) : NLS.bind((String)Messages.LifecycleMappingProposal_execute_label, (Object)goal);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.context == null) {
            return null;
        }
        String pluginGroupId = this.marker.getAttribute("groupId", "");
        String pluginArtifactId = this.marker.getAttribute("artifactId", "");
        String pluginVersion = this.marker.getAttribute("version", "");
        String goal = this.marker.getAttribute("goal", "");
        String execution = this.marker.getAttribute("executionId", "-");
        String phase = this.marker.getAttribute("lifecyclePhase", "-");
        String info = NLS.bind((String)Messages.LifecycleMappingProposal_all_desc, (Object[])new Object[]{goal, execution, phase, String.valueOf(pluginGroupId) + ":" + pluginArtifactId + ":" + pluginVersion, PluginExecutionAction.ignore.equals((Object)this.action) ? Messages.LifecycleMappingProposal_ignore_desc : Messages.LifecycleMappingProposal_execute_desc});
        return info;
    }

    @Override
    public void run(IMarker[] markers, IProgressMonitor monitor) {
        try {
            if (PluginExecutionAction.ignore.equals((Object)this.action)) {
                this.performIgnore(markers);
            } else {
                ArrayList<LifecycleMappingOperation> lst = new ArrayList<LifecycleMappingOperation>();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker m = iMarkerArray[n2];
                    lst.add(this.createOperation(m));
                    ++n2;
                }
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple((IFile)this.marker.getResource(), (PomEdits.Operation)new PomEdits.CompoundOperation(lst.toArray(new PomEdits.Operation[0])))});
            }
        }
        catch (IOException e) {
            log.error("Error generating code in pom.xml", (Throwable)e);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

