/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.editor.xml.MvnImages;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.NodeOperation;
import org.eclipse.m2e.editor.xml.internal.XmlUtils;
import org.eclipse.m2e.editor.xml.internal.lifecycle.LifecycleMappingProposal;
import org.eclipse.m2e.editor.xml.internal.lifecycle.WorkspaceLifecycleMappingProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PomQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final Logger log = LoggerFactory.getLogger(PomQuickAssistProcessor.class);
    private static final String GROUP_ID_NODE = "groupId";
    private static final String ARTIFACT_ID_NODE = "artifactId";
    private static final String VERSION_NODE = "version";
    public static final String PROJECT_NODE = "project";
    public static final String XSI_VALUE = " xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"";

    public boolean canAssist(IQuickAssistInvocationContext arg0) {
        return true;
    }

    public boolean canFix(Annotation an) {
        MarkerAnnotation mark;
        String hint;
        return an instanceof MarkerAnnotation && (hint = (mark = (MarkerAnnotation)an).getMarker().getAttribute("editor_hint", null)) != null;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Iterator annotationIterator = context.getSourceViewer().getAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            MarkerAnnotation mark = (MarkerAnnotation)annotation;
            try {
                String hint;
                Position position = context.getSourceViewer().getAnnotationModel().getPosition(annotation);
                int lineNum = context.getSourceViewer().getDocument().getLineOfOffset(position.getOffset()) + 1;
                int currentLineNum = context.getSourceViewer().getDocument().getLineOfOffset(context.getOffset()) + 1;
                if (currentLineNum != lineNum || (hint = mark.getMarker().getAttribute("editor_hint", null)) == null) continue;
                if (hint.equals("parent_groupid")) {
                    proposals.add(new IdPartRemovalProposal(context, false, mark));
                    continue;
                }
                if (hint.equals("parent_version")) {
                    proposals.add(new IdPartRemovalProposal(context, true, mark));
                    continue;
                }
                if (hint.equals("managed_dependency_override")) {
                    proposals.add(new ManagedVersionRemovalProposal(context, true, mark));
                    proposals.add(new IgnoreWarningProposal(context, mark, "$NO-MVN-MAN-VER$"));
                    continue;
                }
                if (hint.equals("managed_plugin_override")) {
                    proposals.add(new ManagedVersionRemovalProposal(context, false, mark));
                    proposals.add(new IgnoreWarningProposal(context, mark, "$NO-MVN-MAN-VER$"));
                    continue;
                }
                if (hint.equals("missing_schema")) {
                    proposals.add(new SchemaCompletionProposal(context, mark));
                    continue;
                }
                if (hint.equals("not_covered_mojo_execution")) {
                    this.extractedFromMarkers(proposals, mark);
                    proposals.add(new LifecycleMappingProposal(context, mark, PluginExecutionAction.ignore));
                    proposals.add(new WorkspaceLifecycleMappingProposal(mark.getMarker(), PluginExecutionAction.ignore));
                    continue;
                }
                if (mark.getMarker().getAttribute("severity", 2) != 2 || !hint.equals("implicit_lifecyclemaping")) continue;
                this.extractedFromMarkers(proposals, mark);
                proposals.add(new LifecycleMappingProposal(context, mark, PluginExecutionAction.ignore));
                proposals.add(new WorkspaceLifecycleMappingProposal(mark.getMarker(), PluginExecutionAction.ignore));
            }
            catch (Exception e) {
                MvnIndexPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2e.editor.xml", "Exception in pom quick assist.", (Throwable)e));
            }
        }
        if (proposals.size() > 0) {
            return proposals.toArray(new ICompletionProposal[0]);
        }
        return null;
    }

    private void extractedFromMarkers(List<ICompletionProposal> proposals, MarkerAnnotation mark) {
        if (IDE.getMarkerHelpRegistry().hasResolutions(mark.getMarker())) {
            IMarkerResolution[] resolutions;
            IMarkerResolution[] iMarkerResolutionArray = resolutions = IDE.getMarkerHelpRegistry().getResolutions(mark.getMarker());
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerResolution res = iMarkerResolutionArray[n2];
                if (!res.getClass().getName().contains("org.eclipse.m2e.editor.xml")) {
                    MarkerResolutionProposal prop = new MarkerResolutionProposal(res, mark.getMarker());
                    if (res.getClass().getName().contains("DiscoveryWizardProposal")) {
                        if (!proposals.contains(prop)) {
                            proposals.add(prop);
                        }
                    } else {
                        proposals.add(prop);
                    }
                }
                ++n2;
            }
        }
    }

    public String getErrorMessage() {
        return null;
    }

    static String previewForRemovedElement(IDocument doc, Element removed) {
        if (removed != null && removed instanceof IndexedRegion) {
            IndexedRegion reg = (IndexedRegion)removed;
            try {
                int line = doc.getLineOfOffset(reg.getStartOffset());
                int startLine = doc.getLineOffset(line);
                int prev2 = doc.getLineOffset(Math.max(line - 2, 0));
                String prevString = StringUtils.convertToHTMLContent((String)doc.get(prev2, startLine - prev2));
                int nextLine = Math.min(line + 2, doc.getNumberOfLines() - 1);
                int next2End = doc.getLineOffset(nextLine) + doc.getLineLength(nextLine);
                int next2Start = startLine + doc.getLineLength(line) + 1;
                String nextString = StringUtils.convertToHTMLContent((String)doc.get(next2Start, next2End - next2Start));
                return "<html>...<br>" + prevString + nextString + "...<html>";
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static class IdPartRemovalProposal
    implements ICompletionProposal,
    ICompletionProposalExtension5,
    IMarkerResolution,
    IMarkerResolution2 {
        private IQuickAssistInvocationContext context;
        private final boolean isVersion;
        private final IMarker marker;

        public IdPartRemovalProposal(IQuickAssistInvocationContext context, boolean version, MarkerAnnotation mark) {
            this.context = context;
            this.isVersion = version;
            this.marker = mark.getMarker();
        }

        public IdPartRemovalProposal(IMarker marker, boolean version) {
            this.marker = marker;
            this.isVersion = version;
        }

        public void apply(final IDocument doc) {
            XmlUtils.performOnRootElement(doc, new NodeOperation<Element>(){

                @Override
                public void process(Element node, IStructuredDocument structured) {
                    IdPartRemovalProposal.this.processFix(doc, node, IdPartRemovalProposal.this.isVersion, IdPartRemovalProposal.this.marker);
                }
            });
        }

        private void processFix(IDocument doc, Element root, boolean isversion, IMarker marker) {
            Element value;
            if (root.getNodeName().equals(PomQuickAssistProcessor.PROJECT_NODE) && (value = XmlUtils.findChild(root, isversion ? PomQuickAssistProcessor.VERSION_NODE : PomQuickAssistProcessor.GROUP_ID_NODE)) != null && value instanceof IndexedRegion) {
                IndexedRegion off = (IndexedRegion)value;
                int offset = off.getStartOffset();
                if (offset <= 0) {
                    return;
                }
                Node prev = value.getNextSibling();
                if (prev instanceof Text) {
                    off = (IndexedRegion)prev;
                }
                DeleteEdit edit = new DeleteEdit(offset, off.getEndOffset() - offset);
                try {
                    edit.apply(doc);
                    marker.delete();
                }
                catch (Exception e) {
                    log.error("Unable to remove the element", (Throwable)e);
                }
            }
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.isVersion ? Messages.PomQuickAssistProcessor_title_version : Messages.PomQuickAssistProcessor_title_groupId;
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        }

        public Point getSelection(IDocument arg0) {
            return null;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.context == null) {
                return Messages.PomQuickAssistProcessor_remove_hint;
            }
            final IDocument doc = this.context.getSourceViewer().getDocument();
            final String[] toRet = new String[1];
            XmlUtils.performOnRootElement(doc, new NodeOperation<Element>(){

                @Override
                public void process(Element root, IStructuredDocument structured) {
                    if (root.getNodeName().equals(PomQuickAssistProcessor.PROJECT_NODE)) {
                        Element value = XmlUtils.findChild(root, IdPartRemovalProposal.this.isVersion ? PomQuickAssistProcessor.VERSION_NODE : PomQuickAssistProcessor.GROUP_ID_NODE);
                        toRet[0] = PomQuickAssistProcessor.previewForRemovedElement(doc, value);
                    }
                }
            });
            if (toRet[0] != null) {
                return toRet[0];
            }
            return Messages.PomQuickAssistProcessor_remove_hint;
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(final IMarker marker) {
            try {
                XmlUtils.performOnRootElement((IFile)marker.getResource(), new NodeOperation<Element>(){

                    @Override
                    public void process(Element node, IStructuredDocument structured) {
                        IdPartRemovalProposal.this.processFix((IDocument)structured, node, IdPartRemovalProposal.this.isVersion, marker);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error processing marker", (Throwable)e);
            }
            catch (CoreException e) {
                log.error("Error processing marker", (Throwable)e);
            }
        }

        public String getDescription() {
            return (String)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        }
    }

    static class IgnoreWarningProposal
    implements ICompletionProposal,
    ICompletionProposalExtension5,
    IMarkerResolution,
    IMarkerResolution2 {
        private IQuickAssistInvocationContext context;
        private final IMarker marker;
        private final String markupText;

        public IgnoreWarningProposal(IQuickAssistInvocationContext context, MarkerAnnotation mark, String markupText) {
            this.context = context;
            this.marker = mark.getMarker();
            this.markupText = markupText;
        }

        public IgnoreWarningProposal(IMarker marker, String markupText) {
            this.marker = marker;
            this.markupText = markupText;
        }

        public void apply(IDocument doc) {
            XmlUtils.performOnRootElement(doc, new NodeOperation<Element>(){

                @Override
                public void process(Element node, IStructuredDocument structured) {
                    IgnoreWarningProposal.this.processFix(structured, IgnoreWarningProposal.this.marker);
                }
            });
        }

        private void processFix(IStructuredDocument doc, IMarker marker) {
            block12: {
                IDOMModel domModel = null;
                try {
                    int line;
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)doc);
                    if (this.context != null) {
                        line = doc.getLineOfOffset(this.context.getOffset());
                    } else {
                        line = marker.getAttribute("lineNumber", -1);
                        assert (line != -1);
                        --line;
                    }
                    try {
                        int linestart = doc.getLineOffset(line);
                        int lineend = linestart + doc.getLineLength(line);
                        int start = linestart;
                        IndexedRegion reg = domModel.getIndexedRegion(start);
                        while (reg != null && !(reg instanceof Element) && start < lineend) {
                            if ((reg = domModel.getIndexedRegion(reg.getEndOffset() + 1)) == null) continue;
                            start = reg.getStartOffset();
                        }
                        if (reg == null || !(reg instanceof Element)) break block12;
                        InsertEdit edit = new InsertEdit(reg.getEndOffset(), "<!--" + this.markupText + "-->");
                        try {
                            edit.apply((IDocument)doc);
                            marker.delete();
                        }
                        catch (Exception e) {
                            log.error("Unable to insert", (Throwable)e);
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
                finally {
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return "Ignore this warning";
        }

        public Image getImage() {
            return MvnImages.IMG_CLOSE;
        }

        public Point getSelection(IDocument arg0) {
            return null;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            block12: {
                if (this.context == null) {
                    return "Adds comment markup next to the affected element. No longer shows the warning afterwards";
                }
                IDOMModel domModel = null;
                try {
                    IDocument doc = this.context.getSourceViewer().getDocument();
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(doc);
                    int line = doc.getLineOfOffset(this.context.getOffset());
                    int linestart = doc.getLineOffset(line);
                    int lineend = linestart + doc.getLineLength(line);
                    int start = linestart;
                    IndexedRegion reg = domModel.getIndexedRegion(start);
                    while (reg != null && !(reg instanceof Element) && start < lineend) {
                        if ((reg = domModel.getIndexedRegion(reg.getEndOffset() + 1)) == null) continue;
                        start = reg.getStartOffset();
                    }
                    if (reg == null || !(reg instanceof Element)) break block12;
                    try {
                        String currentLine = StringUtils.convertToHTMLContent((String)doc.get(reg.getStartOffset(), reg.getEndOffset() - reg.getStartOffset()));
                        String insert = StringUtils.convertToHTMLContent((String)("<!--" + this.markupText + "-->"));
                        String string = "<html>...<br>" + currentLine + "<b>" + insert + "</b><br>...<html>";
                        return string;
                    }
                    catch (BadLocationException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (BadLocationException e1) {
                            log.error("Error while computing completion proposal", (Throwable)e1);
                        }
                    }
                }
                finally {
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
            return "Adds comment markup next to the affected element. No longer shows the warning afterwards";
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(final IMarker marker) {
            try {
                XmlUtils.performOnRootElement((IFile)marker.getResource(), new NodeOperation<Element>(){

                    @Override
                    public void process(Element node, IStructuredDocument structured) {
                        IgnoreWarningProposal.this.processFix(structured, marker);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error processing marker", (Throwable)e);
            }
            catch (CoreException e) {
                log.error("Error processing marker", (Throwable)e);
            }
        }

        public String getDescription() {
            return (String)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        }
    }

    static class ManagedVersionRemovalProposal
    implements ICompletionProposal,
    ICompletionProposalExtension5,
    IMarkerResolution,
    IMarkerResolution2 {
        private IQuickAssistInvocationContext context;
        private final boolean isDependency;
        private final IMarker marker;

        public ManagedVersionRemovalProposal(IQuickAssistInvocationContext context, boolean dependency, MarkerAnnotation mark) {
            this.context = context;
            this.isDependency = dependency;
            this.marker = mark.getMarker();
        }

        public ManagedVersionRemovalProposal(IMarker marker, boolean dependency) {
            this.marker = marker;
            this.isDependency = dependency;
        }

        public void apply(final IDocument doc) {
            XmlUtils.performOnRootElement(doc, new NodeOperation<Element>(){

                @Override
                public void process(Element node, IStructuredDocument structured) {
                    ManagedVersionRemovalProposal.this.processFix(doc, node, ManagedVersionRemovalProposal.this.isDependency, ManagedVersionRemovalProposal.this.marker);
                }
            });
        }

        private void processFix(IDocument doc, Element root, boolean isdep, IMarker marker) {
            if (root.getNodeName().equals(PomQuickAssistProcessor.PROJECT_NODE)) {
                Element artifact = this.findArtifactElement(root, isdep, marker);
                if (artifact == null) {
                    log.error("Unable to find the marked element");
                    return;
                }
                Element value = XmlUtils.findChild(artifact, PomQuickAssistProcessor.VERSION_NODE);
                if (value != null && value instanceof IndexedRegion) {
                    IndexedRegion off = (IndexedRegion)value;
                    int offset = off.getStartOffset();
                    if (offset <= 0) {
                        return;
                    }
                    Node prev = value.getNextSibling();
                    if (prev instanceof Text) {
                        off = (IndexedRegion)prev;
                    }
                    DeleteEdit edit = new DeleteEdit(offset, off.getEndOffset() - offset);
                    try {
                        edit.apply(doc);
                        marker.delete();
                    }
                    catch (Exception e) {
                        log.error("Unable to remove the element", (Throwable)e);
                    }
                }
            }
        }

        private Element findArtifactElement(Element root, boolean isdep, IMarker marker) {
            Element profileRoot;
            if (root == null) {
                return null;
            }
            String groupId = marker.getAttribute(PomQuickAssistProcessor.GROUP_ID_NODE, null);
            String artifactId = marker.getAttribute(PomQuickAssistProcessor.ARTIFACT_ID_NODE, null);
            assert (groupId != null);
            assert (artifactId != null);
            String profile = marker.getAttribute("profile", null);
            Element artifactParent = root;
            if (profile != null && (profileRoot = XmlUtils.findChild(root, "profiles")) != null) {
                for (Element prf : XmlUtils.findChilds(profileRoot, "profile")) {
                    if (!profile.equals(XmlUtils.getTextValue(XmlUtils.findChild(prf, "id")))) continue;
                    artifactParent = prf;
                    break;
                }
            }
            if (!isdep) {
                artifactParent = XmlUtils.findChild(artifactParent, "build");
            }
            if (artifactParent == null) {
                return null;
            }
            Element list = XmlUtils.findChild(artifactParent, isdep ? "dependencies" : "plugins");
            if (list == null) {
                return null;
            }
            Element artifact = null;
            for (Element art : XmlUtils.findChilds(list, isdep ? "dependency" : "plugin")) {
                String grpString = XmlUtils.getTextValue(XmlUtils.findChild(art, PomQuickAssistProcessor.GROUP_ID_NODE));
                String artString = XmlUtils.getTextValue(XmlUtils.findChild(art, PomQuickAssistProcessor.ARTIFACT_ID_NODE));
                if (!groupId.equals(grpString) || !artifactId.equals(artString)) continue;
                artifact = art;
                break;
            }
            return artifact;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return Messages.PomQuickAssistProcessor_title_version;
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        }

        public Point getSelection(IDocument arg0) {
            return null;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.context == null) {
                return Messages.PomQuickAssistProcessor_remove_hint;
            }
            final IDocument doc = this.context.getSourceViewer().getDocument();
            final String[] toRet = new String[1];
            XmlUtils.performOnRootElement(doc, new NodeOperation<Element>(){

                @Override
                public void process(Element node, IStructuredDocument structured) {
                    Element artifact = ManagedVersionRemovalProposal.this.findArtifactElement(node, ManagedVersionRemovalProposal.this.isDependency, ManagedVersionRemovalProposal.this.marker);
                    if (artifact != null) {
                        Element value = XmlUtils.findChild(artifact, PomQuickAssistProcessor.VERSION_NODE);
                        toRet[0] = PomQuickAssistProcessor.previewForRemovedElement(doc, value);
                    }
                }
            });
            if (toRet[0] != null) {
                return toRet[0];
            }
            return Messages.PomQuickAssistProcessor_remove_hint;
        }

        public String getLabel() {
            return this.getDisplayString();
        }

        public void run(final IMarker marker) {
            try {
                XmlUtils.performOnRootElement((IFile)marker.getResource(), new NodeOperation<Element>(){

                    @Override
                    public void process(Element node, IStructuredDocument structured) {
                        ManagedVersionRemovalProposal.this.processFix((IDocument)structured, node, ManagedVersionRemovalProposal.this.isDependency, marker);
                    }
                });
            }
            catch (IOException e) {
                log.error("Error processing marker", (Throwable)e);
            }
            catch (CoreException e) {
                log.error("Error processing marker", (Throwable)e);
            }
        }

        public String getDescription() {
            return (String)this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public class MarkerResolutionProposal
    implements ICompletionProposal {
        private final IMarkerResolution resolution;
        private final IMarker marker;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.resolution == null ? 0 : this.resolution.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MarkerResolutionProposal)) {
                return false;
            }
            MarkerResolutionProposal other = (MarkerResolutionProposal)obj;
            return !(this.resolution == null ? other.resolution != null : !this.resolution.equals(other.resolution));
        }

        public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
            this.resolution = resolution;
            this.marker = marker;
        }

        public void apply(IDocument document) {
            this.resolution.run(this.marker);
        }

        public String getAdditionalProposalInfo() {
            if (this.resolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.resolution).getDescription();
            }
            String problemDesc = this.marker.getAttribute("message", null);
            if (problemDesc != null) {
                return problemDesc;
            }
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return this.resolution.getLabel();
        }

        public Image getImage() {
            if (this.resolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.resolution).getImage();
            }
            return null;
        }

        public Point getSelection(IDocument document) {
            return null;
        }
    }

    class SchemaCompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension5 {
        IQuickAssistInvocationContext context;
        private MarkerAnnotation annotation;

        public SchemaCompletionProposal(IQuickAssistInvocationContext context, MarkerAnnotation mark) {
            this.context = context;
            this.annotation = mark;
        }

        public void apply(IDocument doc) {
            IDOMModel domModel = null;
            try {
                domModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForRead(doc);
                Element root = domModel.getDocument().getDocumentElement();
                if (root.getNodeName().equals(PomQuickAssistProcessor.PROJECT_NODE) && root instanceof IndexedRegion) {
                    IndexedRegion off = (IndexedRegion)root;
                    int offset = off.getStartOffset() + PomQuickAssistProcessor.PROJECT_NODE.length() + 1;
                    if (offset <= 0) {
                        return;
                    }
                    InsertEdit edit = new InsertEdit(offset, PomQuickAssistProcessor.XSI_VALUE);
                    try {
                        edit.apply(doc);
                        this.annotation.getMarker().delete();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IEditorPart activeEditor = MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                MvnIndexPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveEditor(activeEditor, false);
                            }
                        });
                    }
                    catch (Exception e) {
                        log.error("Unable to insert schema info", (Throwable)e);
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getDisplayString() {
            return Messages.PomQuickAssistProcessor_name;
        }

        public Image getImage() {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        }

        public Point getSelection(IDocument arg0) {
            return null;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            return "<html>...<br>&lt;project <b> xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\nxsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"</b>&gt;<br>...</html>";
        }
    }
}

