/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.jaxrs.wadl.model.services;

import oracle.eclipse.tools.jaxrs.jdt.ProjectPathUtil;
import oracle.eclipse.tools.jaxrs.util.JAXRSUtil;
import oracle.eclipse.tools.jaxrs.wadl.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public class JaxrsProjectValidator
extends ValidationService {
    protected Status compute() {
        ReferenceValue value = (ReferenceValue)this.context(ReferenceValue.class);
        String val = value.text(false);
        if (val != null) {
            IStatus status;
            IProject project = (IProject)value.resolve();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null && (status = ProjectPathUtil.validateExpectedJaxrsProjectClasspath(javaProject)) != null && !status.isOK()) {
                String msg = status.getMessage();
                msg = !msg.endsWith(".") ? String.valueOf(msg) + ". " : String.valueOf(msg) + " ";
                msg = String.valueOf(msg) + Messages.generate_wadl_2_java_notAJAXRSEnabledProject;
                if (status.getSeverity() == 4) {
                    return Status.createErrorStatus((String)msg);
                }
                if (status.getSeverity() == 2) {
                    return Status.createWarningStatus((String)msg);
                }
            }
            try {
                if (FacetedProjectFramework.isFacetedProject((IProject)project) && !JAXRSUtil.hasJaxrsFacetInstalled(project)) {
                    return Status.createWarningStatus((String)Messages.generate_wadl_2_java_noJAXRSFacet);
                }
            }
            catch (CoreException coreException) {
                return Status.createWarningStatus((String)Messages.generate_wadl_2_java_unableToDetermineProject);
            }
        }
        return Status.createOkStatus();
    }
}

